/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.instrumentation.domain;

import com.paypal.android.instrumentation.base.commons.lang.Action;
import com.paypal.instrumentation.domain.AbstractEvent;
import com.paypal.instrumentation.domain.Page;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PageBuilder {
    private Page _parent;
    private String _name;
    private Map<String, String> _additionalInfo = new HashMap<String, String>();
    private Action<Map<String, String>, Void> _additionalInfoEvaluator;
    private static String s_platform;

    public static void setPlatform(String platform) {
        s_platform = platform;
    }

    public PageBuilder setParent(Page parent) {
        this._parent = parent;
        return this;
    }

    public PageBuilder setName(String name) {
        this._name = name;
        return this;
    }

    public PageBuilder setAdditionalInfoEvaluator(Action<Map<String, String>, Void> additionalInfoEvaluator) {
        this._additionalInfoEvaluator = additionalInfoEvaluator;
        return this;
    }

    public Page create() {
        return new PageImpl(this._parent, this._name, this._additionalInfo, this._additionalInfoEvaluator);
    }

    static class PageImpl
    extends AbstractEvent
    implements Page {
        private final Action<Map<String, String>, Void> _additionalInfoEvaluator;
        private Page _parent;
        private String _name;
        private Map<String, String> _additionalInfo = Collections.emptyMap();

        PageImpl(Page parent, String name, Map<String, String> additionalInfo, Action<Map<String, String>, Void> additionalInfoEvaluator) {
            this._parent = parent;
            this._name = name;
            this._additionalInfo = additionalInfo;
            this._additionalInfoEvaluator = additionalInfoEvaluator;
        }

        @Override
        public Page getParent() {
            return this._parent;
        }

        @Override
        public boolean hasParent() {
            return this._parent != null;
        }

        @Override
        public String getFullPageName() {
            if (this.hasParent()) {
                if (this._parent.hasParent()) {
                    return this._parent.getParent().getPageName() + ":" + this._parent.getPageName() + ":" + this._name;
                }
                return this._parent.getPageName() + "::" + this._name;
            }
            return this.getPageName() + "::";
        }

        @Override
        public String getPageName() {
            return this._name;
        }

        @Override
        public Map<String, String> getAdditionalInfo() {
            return this._additionalInfoEvaluator == null ? this._additionalInfo : (Map)this._additionalInfoEvaluator.invoke(null);
        }

        @Override
        public void setPageName(String pageName) {
            this._name = pageName;
        }

        @Override
        public Map<String, String> getParameters() {
            Map<String, String> params = super.getParameters();
            String pageName2 = this.getFullPageName() + ":" + s_platform;
            params.put("pgrp", this.getFullPageName());
            params.put("page", pageName2);
            params.put("e", "im");
            params.putAll(this.getAdditionalInfo());
            return params;
        }
    }
}

