/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.instrumentation.domain;

import com.paypal.android.instrumentation.base.commons.lang.Optional;
import java.util.HashMap;
import java.util.Map;

public class ReportingConfigs {
    private String mParticleApiKey;
    private String mParticleApiSecret;
    private String adjustApiKey;
    private String environment;
    Map<String, String> customInfo;

    public Optional<String> getMParticleAPIKey() {
        return this.mParticleApiKey == null ? Optional.absent() : Optional.of((Object)this.mParticleApiKey);
    }

    public Optional<String> getMParticleAPISecret() {
        return this.mParticleApiSecret == null ? Optional.absent() : Optional.of((Object)this.mParticleApiSecret);
    }

    public Optional<String> getAdjustAPIKey() {
        return this.adjustApiKey == null ? Optional.absent() : Optional.of((Object)this.adjustApiKey);
    }

    public Optional<String> getEnvironment() {
        return this.environment == null ? Optional.absent() : Optional.of((Object)this.environment);
    }

    public Map<String, String> getCustomInfo() {
        return this.customInfo;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ReportingConfigs reportingConfigs) {
        return new Builder(reportingConfigs);
    }

    public static class Builder {
        private String mParticleApiKey;
        private String mParticleApiSecret;
        private String environment;
        private String adjustApiKey;
        private Map<String, String> customInfo = new HashMap<String, String>();

        private Builder() {
        }

        private Builder(ReportingConfigs reportingConfigs) {
            this.setMParticleAPIKey(reportingConfigs.mParticleApiKey);
            this.setMParticleAPISecret(reportingConfigs.mParticleApiSecret);
            this.setAdjustAPIKey(reportingConfigs.adjustApiKey);
            this.setEnvironment(reportingConfigs.environment);
            this.customInfo = reportingConfigs.customInfo;
        }

        public ReportingConfigs build() {
            ReportingConfigs reportingConfigs = new ReportingConfigs();
            reportingConfigs.mParticleApiKey = this.mParticleApiKey;
            reportingConfigs.mParticleApiSecret = this.mParticleApiSecret;
            reportingConfigs.adjustApiKey = this.adjustApiKey;
            reportingConfigs.environment = this.environment;
            reportingConfigs.customInfo = this.customInfo;
            return reportingConfigs;
        }

        public Builder setMParticleAPIKey(String mParticleApiKey) {
            this.mParticleApiKey = mParticleApiKey;
            return this;
        }

        public Builder setMParticleAPISecret(String mParticleApiSecret) {
            this.mParticleApiSecret = mParticleApiSecret;
            return this;
        }

        public Builder setAdjustAPIKey(String adjustAPIKey) {
            this.adjustApiKey = adjustAPIKey;
            return this;
        }

        public Builder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder addCustominfo(String property, String value) {
            this.customInfo.put(property, value);
            return this;
        }
    }
}

