/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.instrumentation.domain.networking;

import com.paypal.android.instrumentation.base.Logging;
import com.paypal.android.instrumentation.base.util.StringUtils;
import com.paypal.instrumentation.domain.ReportingContext;
import com.paypal.instrumentation.domain.ReportingEvent;
import com.paypal.instrumentation.fpti.service.FPTIUtils;
import com.paypal.instrumentation.networking.NetworkEnvironment;
import com.paypal.instrumentation.networking.ServiceRequest;
import com.paypal.instrumentation.networking.domain.AbstractRequest;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class FPTIRequest
extends AbstractRequest {
    ReportingContext _fptiConfiguration;
    String _trackingEvent;
    String _channel;
    String _visitID;
    String _visitorID;
    String _merchantID;
    String _latitude;
    String _longitude;
    boolean _isLoggedIn;
    ReportingEvent _event;
    NetworkEnvironment _networkEnvironment;

    public FPTIRequest(ReportingContext configuration, NetworkEnvironment networkEnvironment, ReportingEvent event, String visitID, String merchantID, boolean isLoggedIn, String latitude, String longitude) {
        this._fptiConfiguration = configuration;
        this._trackingEvent = Long.toString(System.currentTimeMillis());
        this._networkEnvironment = networkEnvironment;
        this._channel = "mobile";
        this._event = event;
        this._visitID = visitID;
        this._latitude = latitude;
        this._longitude = longitude;
        this._isLoggedIn = isLoggedIn;
        this._merchantID = merchantID;
        this._visitorID = this._fptiConfiguration.GUID;
    }

    public String getURI() {
        return "https://api.paypal.com/v1/tracking/events";
    }

    public String getPayloadAsString() {
        JSONObject wrapper = new JSONObject();
        JSONObject payload = new JSONObject();
        JSONObject actor = new JSONObject();
        JSONObject eventParams = new JSONObject();
        try {
            actor.put("tracking_visitor_id", (Object)FPTIUtils.formatVisitorIDForBackend(this._visitorID));
            actor.put("tracking_visit_id", (Object)FPTIUtils.formatVisitIDForBackend(this._visitID));
            Map<String, String> eventParamMap = this._event.getParameters();
            eventParamMap.putAll(this.getAditionalParameters());
            for (Map.Entry<String, String> thisEntry : eventParamMap.entrySet()) {
                String key = thisEntry.getKey();
                String value = thisEntry.getValue();
                if (value == null) continue;
                if (key.toString().equalsIgnoreCase("page") || key.toString().equalsIgnoreCase("pgln") || key.toString().equalsIgnoreCase("pgrp")) {
                    eventParams.put(key.toString(), (Object)(this._fptiConfiguration.server + ":" + this._fptiConfiguration.pageNameComponent + ":" + value.toString()));
                    continue;
                }
                eventParams.put(key.toString(), (Object)value.toString());
            }
            payload.put("actor", (Object)actor);
            payload.put("channel", (Object)"mobile");
            payload.put("event_params", (Object)eventParams);
            payload.put("tracking_event", (Object)this._trackingEvent);
            wrapper.put("events", (Object)payload);
            Logging.d((String)"FPTI", (String)wrapper.toString());
        }
        catch (JSONException e) {
            return "";
        }
        return wrapper.toString();
    }

    private Map<String, String> getAditionalParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fpti", FPTIUtils.formatVisitorIDForBackend(this._visitorID));
        params.put("mrid", this._merchantID);
        params.put("ch", this._fptiConfiguration.channel);
        params.put("bzsr", this._fptiConfiguration.server);
        params.put("vid", this._fptiConfiguration.GUID.replace("-", ""));
        params.put("t", Long.toString(System.currentTimeMillis()));
        params.put("g", "300");
        params.put("srce", "native_app");
        params.put("mapv", this._fptiConfiguration.appVersion + "-" + this._fptiConfiguration.appVersionCode);
        params.put("mosv", this._fptiConfiguration.os + this._fptiConfiguration.osVersion);
        params.put("mdvs", this._fptiConfiguration.deviceName);
        params.put("mcar", this._fptiConfiguration.carrier);
        params.put("vers", this._fptiConfiguration.reportingVersion);
        params.put("rsta", this._fptiConfiguration.displayLanguage);
        if (this._isLoggedIn) {
            params.put("lgin", "in");
        } else {
            params.put("lgin", "out");
        }
        if (StringUtils.isNotEmpty((String)this._latitude) && StringUtils.isNotEmpty((String)this._longitude)) {
            params.put("lalo", this._latitude + ":" + this._longitude);
        }
        return params;
    }

    public Map<String, String> getHeaderValues() {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", "Bearer");
        headerMap.put("X-PAYPAL-APPLICATION-ID", this._fptiConfiguration.appID);
        headerMap.put("User-Agent", this._fptiConfiguration.userAgent);
        headerMap.put("Content-Type", "application/json");
        return headerMap;
    }

    public ServiceRequest.RequestMethod getRequestMethod() {
        return ServiceRequest.RequestMethod.POST;
    }

    public int getMaxRetries() {
        return 3;
    }

    public int getMaxNetworkTimeout() {
        return 20000;
    }

    public ServiceRequest.Priority getPriority() {
        return ServiceRequest.Priority.LOW;
    }
}

