/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.instrumentation.firebase;

import android.content.Context;
import android.os.Bundle;
import com.google.firebase.analytics.FirebaseAnalytics;
import com.paypal.instrumentation.AbstractTrackingService;
import com.paypal.instrumentation.domain.AdditionalReportingInfo;
import com.paypal.instrumentation.domain.Event;
import com.paypal.instrumentation.domain.FirebaseEvent;
import java.util.Map;

public class FirebaseAnalyticsService
extends AbstractTrackingService {
    private FirebaseAnalytics firebaseAnalytics;

    public FirebaseAnalyticsService(Context context) {
        this.firebaseAnalytics = FirebaseAnalytics.getInstance((Context)context);
    }

    @Override
    public void logEvent(Event event, AdditionalReportingInfo additionalReportingInfo) {
        if (event instanceof FirebaseEvent) {
            String eventName = event.getString();
            Bundle bundle = new Bundle();
            bundle.putString("content_type", eventName);
            if (additionalReportingInfo != null && additionalReportingInfo.getCustomInfo() != null) {
                Map<String, String> customInfoMap = additionalReportingInfo.getCustomInfo();
                for (Map.Entry<String, String> customInfo : customInfoMap.entrySet()) {
                    bundle.putString(customInfo.getKey(), customInfo.getValue());
                }
            }
            this.firebaseAnalytics.logEvent(eventName, bundle);
        }
    }
}

