/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.instrumentation.fpti;

import android.app.Activity;
import android.support.v4.app.Fragment;
import android.view.View;
import com.paypal.android.instrumentation.base.Logging;
import com.paypal.android.instrumentation.base.commons.app.ActivityLifecycleListenerAdapter;
import com.paypal.instrumentation.domain.Page;
import com.paypal.instrumentation.domain.ReportingConstants;
import com.paypal.instrumentation.fpti.ReportingDescriptor;
import com.paypal.instrumentation.fpti.ReportingMetadata;
import com.paypal.instrumentation.fpti.ReportingService;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class ReportingActivityLifeCycleListener
extends ActivityLifecycleListenerAdapter {
    private final ReportingService _delegate;
    private ReportingDescriptor _currentReportingDescriptor;
    private ReportingDescriptor _childReportingDescriptor;
    private final Map<Class<? extends ReportingDescriptor>, ReportingDescriptor> _reportingMetaData = new HashMap<Class<? extends ReportingDescriptor>, ReportingDescriptor>();

    public ReportingActivityLifeCycleListener(ReportingService delegate) {
        this._delegate = delegate;
    }

    public void onActivityResumed(Activity activity) {
        Class<?> activityClass = activity.getClass();
        ReportingMetadata reportingMetadata = activityClass.getAnnotation(ReportingMetadata.class);
        this._currentReportingDescriptor = this.onScreenResumed(reportingMetadata, activity);
        this._childReportingDescriptor = null;
    }

    public void onFragmentResumed(Fragment fragment) {
        Class<?> fragmentClass = fragment.getClass();
        ReportingMetadata reportingMetadata = fragmentClass.getAnnotation(ReportingMetadata.class);
        this._childReportingDescriptor = this.onScreenResumed(reportingMetadata, fragment);
    }

    public ReportingDescriptor onScreenResumed(ReportingMetadata reportingMetadata, Object source) {
        ReportingDescriptor reportingDescriptor = null;
        if (reportingMetadata == null) {
            reportingDescriptor = this.tryHandleDynamicDescriptor(source, source.getClass());
        } else {
            Class<? extends ReportingDescriptor> value = reportingMetadata.value();
            boolean useCache = reportingMetadata.useCache();
            if (useCache) {
                if (!this._reportingMetaData.containsKey(value)) {
                    reportingDescriptor = this.createNewReportingDescriptor(value);
                    this.registerDescriptor(value, reportingDescriptor);
                } else {
                    reportingDescriptor = this._reportingMetaData.get(value);
                }
            } else {
                reportingDescriptor = this.createNewReportingDescriptor(value);
                this.registerDescriptor(value, reportingDescriptor);
            }
            Page pageName = reportingDescriptor.getPageName();
            if (pageName != null && !ReportingConstants.IGNORE.getPageName().equals(pageName.getPageName())) {
                this._delegate.logPageView(pageName);
            }
        }
        return reportingDescriptor;
    }

    private ReportingDescriptor tryHandleDynamicDescriptor(Object object, Class<?> objectClass) {
        Field[] declaredFields;
        ReportingDescriptor reportingDescriptor = null;
        for (Field declaredField : declaredFields = objectClass.getFields()) {
            if (!declaredField.isAnnotationPresent(ReportingMetadata.class)) continue;
            try {
                Object value = this.tryGetDescriptorValue(object, declaredField);
                if (value == null) {
                    return null;
                }
                reportingDescriptor = (ReportingDescriptor)value;
                Class<?> reportingDescriptorClass = reportingDescriptor.getClass();
                if (!this._reportingMetaData.containsKey(reportingDescriptorClass)) {
                    this.registerDescriptor(reportingDescriptorClass, reportingDescriptor);
                }
                this._currentReportingDescriptor = reportingDescriptor;
                Page pageName = reportingDescriptor.getPageName();
                if (pageName == null || ReportingConstants.IGNORE.getPageName().equals(pageName.getPageName())) continue;
                this._delegate.logPageView(pageName);
            }
            catch (IllegalAccessException e) {
                Logging.e((String)Logging.LOG_PREFIX, (String)e.getMessage());
            }
        }
        return reportingDescriptor;
    }

    private Object tryGetDescriptorValue(Object object, Field declaredField) throws IllegalAccessException {
        try {
            if (!declaredField.isAccessible()) {
                declaredField.setAccessible(true);
            }
            return declaredField.get(object);
        }
        catch (NullPointerException exception) {
            return null;
        }
    }

    public void onActivityPaused(Activity activity) {
        this._currentReportingDescriptor = null;
    }

    public void onViewClicked(View view) {
        if (view == null) {
            return;
        }
        int id = view.getId();
        if (this._currentReportingDescriptor != null) {
            if (this._currentReportingDescriptor.getLinks().containsKey(id)) {
                this._delegate.logLink(this._currentReportingDescriptor.getLinks().get(id));
            } else if (this._childReportingDescriptor != null && this._childReportingDescriptor.getLinks().containsKey(id)) {
                this._delegate.logLink(this._childReportingDescriptor.getLinks().get(id));
            }
        }
    }

    private void registerDescriptor(Class<? extends ReportingDescriptor> value, ReportingDescriptor reportingDescriptor) {
        if (reportingDescriptor != null) {
            this._reportingMetaData.put(value, reportingDescriptor);
        }
    }

    private <T extends ReportingDescriptor> T createNewReportingDescriptor(Class<T> value) {
        try {
            return (T)((ReportingDescriptor)value.newInstance());
        }
        catch (InstantiationException e) {
            Logging.e((String)Logging.LOG_PREFIX, (String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            Logging.e((String)Logging.LOG_PREFIX, (String)e.getMessage());
        }
        return null;
    }
}

