/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.instrumentation.fpti.service;

import com.paypal.android.instrumentation.base.Logging;
import com.paypal.instrumentation.domain.ReportingContext;
import com.paypal.instrumentation.domain.ReportingEvent;
import com.paypal.instrumentation.domain.networking.FPTIRequest;
import com.paypal.instrumentation.domain.networking.FPTIResponse;
import com.paypal.instrumentation.fpti.service.FPTI;
import com.paypal.instrumentation.fpti.service.FPTIUtils;
import com.paypal.instrumentation.networking.InternalServiceCallback;
import com.paypal.instrumentation.networking.NetworkEnvironment;
import com.paypal.instrumentation.networking.ServiceRequest;
import java.util.ArrayList;
import java.util.List;

public class FPTIImpl
implements FPTI {
    public static final int MAX_QUEUE_SIZE = 25;
    private String _visitID = "";
    private String _merchantAccountId = null;
    private String _latitude = "";
    private String _longitude = "";
    private static boolean _isLoggedIn = false;
    private NetworkEnvironment _networkEnvironment;
    private ReportingContext _fptiConfiguration;
    private List<FPTIRequest> _eventList = new ArrayList<FPTIRequest>();

    private FPTIImpl() {
    }

    public static FPTI getInstance() {
        return Lazy.INSTANCE;
    }

    @Override
    public void init(ReportingContext config, NetworkEnvironment networkEnvironment) {
        this._fptiConfiguration = config;
        this._networkEnvironment = networkEnvironment;
    }

    @Override
    public void logEvent(ReportingEvent event) {
        FPTIRequest request = new FPTIRequest(this._fptiConfiguration, this._networkEnvironment, event, this._visitID, this._merchantAccountId, _isLoggedIn, this._latitude, this._longitude);
        this.enqueueRequest(request);
    }

    private void enqueueRequest(FPTIRequest request) {
        this._eventList.add(request);
        if (this._eventList.size() >= 25) {
            this.sendQueuedRequests();
        }
    }

    private void sendQueuedRequests() {
        final FPTIResponse response = new FPTIResponse();
        InternalServiceCallback<FPTIResponse> internalServiceCallback = new InternalServiceCallback<FPTIResponse>(){

            public void invoke(FPTIResponse response2) {
                if (response2.isSuccess()) {
                    Logging.i((String)"FPTI", (String)("Request logged successfully" + response2.getNetworkResponse().statusCode));
                } else if (response2.getNetworkResponse() != null) {
                    Logging.i((String)"FPTI", (String)("Request Failed to log" + response2.getNetworkResponse().statusCode));
                }
            }

            public FPTIResponse getResponse() {
                return response;
            }
        };
        for (FPTIRequest request : this._eventList) {
            Logging.d((String)"FPTI", (String)request.getURI().toString());
            this._networkEnvironment.getNetworkClient().submit((ServiceRequest)request, (InternalServiceCallback)internalServiceCallback);
        }
        this._eventList.clear();
    }

    @Override
    public void setLocation(String latitude, String longitude) {
        this._latitude = latitude;
        this._longitude = longitude;
    }

    @Override
    public void logLogin(boolean isEmail, String accountID, String countryCode, String sessionID) {
        _isLoggedIn = true;
        this._merchantAccountId = accountID;
        this._visitID = sessionID;
        ReportingEvent event = FPTIUtils.getLoginEvent(isEmail, accountID, countryCode, sessionID);
        this.logEvent(event);
    }

    @Override
    public void logLogout() {
        _isLoggedIn = false;
        this._merchantAccountId = null;
        this._visitID = "";
    }

    private static class Lazy {
        private static final FPTIImpl INSTANCE = new FPTIImpl();

        private Lazy() {
        }
    }
}

