/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.instrumentation.fpti.service;

import com.paypal.android.instrumentation.base.util.StringUtils;
import com.paypal.instrumentation.domain.AbstractEvent;
import com.paypal.instrumentation.domain.ReportingEvent;
import java.util.Map;

public class FPTIUtils {
    public static String formatVisitIDForBackend(String visitID) {
        if (StringUtils.isEmpty((String)visitID)) {
            return "";
        }
        int MAX_VISITOR_ID_LENGTH = 80;
        String alphanumericVisitID = visitID.replaceAll("[^A-Za-z0-9]", "");
        if (alphanumericVisitID.length() > 80) {
            alphanumericVisitID = alphanumericVisitID.substring(0, 80);
        }
        return alphanumericVisitID;
    }

    public static String formatVisitorIDForBackend(String guid) {
        return guid.replaceAll("[^\\dA-Za-z ]", "").replaceAll("\\s+", "+");
    }

    public static ReportingEvent getLoginEvent(boolean isEmail, String accountID, String countryCode, String sessionID) {
        return new Login(isEmail, accountID, countryCode, sessionID);
    }

    private static class Login
    extends AbstractEvent {
        boolean _isEmail;
        String _accountID;
        String _countryCode;
        String _sessionID;

        public Login(boolean isEmail, String accountID, String countryCode, String sessionID) {
            this._isEmail = isEmail;
            this._accountID = accountID;
            this._countryCode = countryCode;
            this._sessionID = sessionID;
        }

        @Override
        public Map<String, String> getParameters() {
            Map<String, String> params = super.getParameters();
            params.put("cnac", this._countryCode);
            params.put("rvid", this._sessionID);
            params.put("login_password", String.valueOf(this._isEmail));
            params.put("login_pin", String.valueOf(!this._isEmail));
            params.put("e", "im");
            return params;
        }
    }
}

