/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.instrumentation.mParticle;

import android.content.Context;
import com.mparticle.AttributionError;
import com.mparticle.AttributionListener;
import com.mparticle.AttributionResult;
import com.mparticle.MPEvent;
import com.mparticle.MParticle;
import com.mparticle.MParticleOptions;
import com.mparticle.identity.IdentityApiRequest;
import com.mparticle.identity.IdentityApiResult;
import com.mparticle.identity.IdentityHttpResponse;
import com.mparticle.identity.MParticleUser;
import com.mparticle.identity.TaskFailureListener;
import com.mparticle.identity.TaskSuccessListener;
import com.paypal.instrumentation.AbstractTrackingService;
import com.paypal.instrumentation.IReportingEnum;
import com.paypal.instrumentation.domain.AdditionalReportingInfo;
import com.paypal.instrumentation.domain.Event;
import com.paypal.instrumentation.domain.MParticleEvent;
import com.paypal.instrumentation.domain.MParticlePage;
import com.paypal.instrumentation.domain.Page;
import com.paypal.instrumentation.domain.ReportingConfigs;
import com.paypal.instrumentation.mParticle.MParticleConstants;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MParticleAnalyticsService
extends AbstractTrackingService
implements AttributionListener {
    private Context context;
    private MParticle mParticle;

    public MParticleAnalyticsService(Context context) {
        this.context = context;
    }

    @Override
    public void startService(ReportingConfigs reportingConfigs) {
        MParticleOptions options = MParticleOptions.builder((Context)this.context).credentials((String)reportingConfigs.getMParticleAPIKey().getValue(), (String)reportingConfigs.getMParticleAPISecret().getValue()).environment(MParticle.Environment.AutoDetect).installType(MParticle.InstallType.AutoDetect).attributionListener((AttributionListener)this).build();
        MParticle.start((MParticleOptions)options);
        this.mParticle = MParticle.getInstance();
    }

    @Override
    public void logEvent(Event event, AdditionalReportingInfo additionalReportingInfo) {
        if (event instanceof MParticleEvent) {
            String eventName = event.getString();
            MParticle.EventType eventType = MParticle.EventType.Navigation;
            Map<String, String> eventInfo = additionalReportingInfo != null ? additionalReportingInfo.getCustomInfo() : null;
            MPEvent mpEvent = new MPEvent.Builder(eventName, eventType).info(eventInfo).build();
            this.mParticle.logEvent(mpEvent);
        }
    }

    @Override
    public void logUserAttributes(final Map<IReportingEnum, Object> attributes) {
        if (attributes != null && attributes.containsKey(MParticleConstants.UserAttributes.CUSTOMER_ID)) {
            final IdentityApiRequest apiRequest = IdentityApiRequest.withEmptyUser().customerId(attributes.get(MParticleConstants.UserAttributes.CUSTOMER_ID).toString()).build();
            this.mParticle.Identity().login(apiRequest).addFailureListener(new TaskFailureListener(){

                public void onFailure(IdentityHttpResponse identityHttpResponse) {
                    MParticleAnalyticsService.this.mParticle.Identity().login(apiRequest);
                }
            }).addSuccessListener(new TaskSuccessListener(){

                public void onSuccess(IdentityApiResult identityApiResult) {
                    MParticleAnalyticsService.this.setAttributes(attributes);
                }
            });
            attributes.remove(MParticleConstants.UserAttributes.CUSTOMER_ID);
        } else {
            this.setAttributes(attributes);
        }
    }

    private void setAttributes(Map<IReportingEnum, Object> attributes) {
        HashMap<String, Object> userAttributes = new HashMap<String, Object>();
        MParticleUser currentUser = this.mParticle.Identity().getCurrentUser();
        if (currentUser != null && attributes != null) {
            for (Map.Entry<IReportingEnum, Object> entry : attributes.entrySet()) {
                if (MParticleConstants.UserAttributes.TPV == entry.getKey()) {
                    this.setTPVAndTransactionCount(userAttributes, currentUser, entry);
                    continue;
                }
                if (MParticleConstants.UserAttributes.CARD_READER_TYPES == entry.getKey()) {
                    this.setReaderTypes(userAttributes, currentUser, entry);
                    continue;
                }
                if (MParticleConstants.UserAttributes.DEVICE_IDS == entry.getKey()) {
                    this.setDeviceIds(userAttributes, currentUser, entry);
                    continue;
                }
                if (MParticleConstants.UserAttributes.ACTIVATION_STATUS == entry.getKey()) {
                    this.setActivationStatus(userAttributes, currentUser, entry);
                    continue;
                }
                userAttributes.put(entry.getKey().getString(), entry.getValue());
            }
            currentUser.setUserAttributes(userAttributes);
        }
    }

    @Override
    public void onLogout() {
        this.mParticle.Identity().logout();
        this.logEvent(MParticleConstants.MParticleEvents.LOGOUT, null);
    }

    private void setReaderTypes(Map<String, Object> userAttributes, MParticleUser currentUser, Map.Entry<IReportingEnum, Object> entry) {
        Object readerTypeList = currentUser.getUserAttributes().get(MParticleConstants.UserAttributes.CARD_READER_TYPES.getString());
        if (readerTypeList == null) {
            readerTypeList = new ArrayList();
            ((List)readerTypeList).add(entry.getValue());
            userAttributes.put(MParticleConstants.UserAttributes.CARD_READER_TYPES.getString(), readerTypeList);
        } else if (readerTypeList instanceof List && !((List)readerTypeList).contains(entry.getValue())) {
            ((List)readerTypeList).add(entry.getValue());
            userAttributes.put(MParticleConstants.UserAttributes.CARD_READER_TYPES.getString(), readerTypeList);
        }
    }

    private void setDeviceIds(Map<String, Object> userAttributes, MParticleUser currentUser, Map.Entry<IReportingEnum, Object> entry) {
        Object deviceIdList = currentUser.getUserAttributes().get(MParticleConstants.UserAttributes.DEVICE_IDS.getString());
        if (deviceIdList == null) {
            deviceIdList = new ArrayList();
            ((List)deviceIdList).add(entry.getValue());
            userAttributes.put(MParticleConstants.UserAttributes.DEVICE_IDS.getString(), deviceIdList);
        } else if (deviceIdList instanceof List && !((List)deviceIdList).contains(entry.getValue())) {
            ((List)deviceIdList).add(entry.getValue());
            userAttributes.put(MParticleConstants.UserAttributes.DEVICE_IDS.getString(), deviceIdList);
        }
    }

    private void setActivationStatus(Map<String, Object> userAttributes, MParticleUser currentUser, Map.Entry<IReportingEnum, Object> entry) {
        BigDecimal currentTxnCount;
        Object txnCount = currentUser.getUserAttributes().get(MParticleConstants.UserAttributes.TRANSACTION_COUNT.getString());
        BigDecimal bigDecimal = currentTxnCount = txnCount == null ? BigDecimal.ZERO : new BigDecimal(txnCount.toString());
        if (entry.getValue() instanceof String && ((String)entry.getValue()).equalsIgnoreCase(MParticleConstants.ENABLED) && currentTxnCount.compareTo(BigDecimal.ZERO) > 0) {
            userAttributes.put(MParticleConstants.UserAttributes.ACTIVATION_STATUS.getString(), MParticleConstants.ACTIVATED);
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            userAttributes.put(MParticleConstants.UserAttributes.ACTIVATION_DATE.getString(), dateFormat.format(new Date()));
        }
    }

    private void setTPVAndTransactionCount(Map<String, Object> userAttributes, MParticleUser currentUser, Map.Entry<IReportingEnum, Object> entry) {
        BigDecimal currentTPVValue;
        Object currentTPV = currentUser.getUserAttributes().get(MParticleConstants.UserAttributes.TPV.getString());
        BigDecimal bigDecimal = currentTPVValue = currentTPV == null ? BigDecimal.ZERO : new BigDecimal(currentTPV.toString());
        if (entry.getValue() instanceof BigDecimal) {
            BigDecimal newTPV = (BigDecimal)entry.getValue();
            userAttributes.put(entry.getKey().getString(), currentTPVValue.add(newTPV));
            currentUser.incrementUserAttribute(MParticleConstants.UserAttributes.TRANSACTION_COUNT.getString(), 1);
        }
    }

    @Override
    public void logPageView(Page page) {
        if (page instanceof MParticlePage) {
            this.mParticle.logScreen(page.getPageName());
        }
    }

    @Override
    public void beginTransaction(String transactionName) {
    }

    public void onResult(AttributionResult attributionResult) {
    }

    public void onError(AttributionError attributionError) {
    }
}

