/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base;

import android.app.Application;
import android.content.Context;
import android.telephony.TelephonyManager;
import com.paypal.android.instrumentation.base.CoreEnvironment;
import com.paypal.android.instrumentation.base.PerCountryInterface;
import com.paypal.android.instrumentation.base.domain.Country;
import com.paypal.android.instrumentation.base.util.CurrencyUtil;
import com.paypal.android.instrumentation.base.util.SharedPreferenceUtil;
import java.util.Currency;
import java.util.UUID;

public class Core {
    private static final String LOG_TAG = "Core";
    private static final String INSTALL_GUID = "InstallationGUID";
    private static CoreEnvironment m_env = null;
    private static PerCountryInterface m_pci;

    private Core() {
    }

    public static void Init(Application app, CoreEnvironment env, PerCountryInterface pci, String server) {
        m_env = env;
        m_pci = pci;
        Core.setup_install_guid();
    }

    private static void setup_install_guid() {
        if (Core.getInstallationGUID() == null) {
            SharedPreferenceUtil.setPreference(Core.getContext(), INSTALL_GUID, UUID.randomUUID().toString());
        }
    }

    public static String getInstallationGUID() {
        return SharedPreferenceUtil.getStringPreference(Core.getContext(), INSTALL_GUID, null);
    }

    public static PerCountryInterface getPerCountryInterface() {
        return m_pci;
    }

    public static String getVersion() {
        return m_env.getVersion();
    }

    public static void setForceUpgradeOnNextMEPDI(boolean b) {
        m_env.setForceUpgradeOnNextMEPDI(b);
    }

    public static Context getContext() {
        return m_env.getContext();
    }

    public static Currency getDefaultCurrency() {
        return m_pci.getCurrencyForCountry(Core.getCurrentCountry());
    }

    public static Country getCurrentCountry() {
        return m_pci.getDefaultCountry();
    }

    public static String getCurrentCurrencyCode() {
        return CurrencyUtil.getCurrencyCodeForCountry(m_pci.getDefaultCountry().getCode());
    }

    public static String getPhonesPhoneNumber(Country c) {
        String prefix;
        TelephonyManager m = (TelephonyManager)Core.getContext().getSystemService("phone");
        String s = m.getLine1Number();
        if (s != null && (prefix = m_pci.getDialingPrefix(c)) != null && s.startsWith(prefix)) {
            s = s.substring(prefix.length());
        }
        return s;
    }

    public static String getPrefsFile() {
        return m_env.getPrefsFile();
    }

    public static boolean isDebug() {
        return m_env.isDebug();
    }
}

