/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base;

import com.paypal.android.instrumentation.base.Logging;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public class TokenManager {
    private static final String LOG_TAG = "TokenManager";
    public static final String EXPIRED_TOKEN = "expired";
    private static String m_session_token = "";
    private static String m_access_token = "";
    private static String m_refresh_token = "";
    private static List<SessionTokenHistory> sessionTokenHistory = new ArrayList<SessionTokenHistory>();

    private TokenManager() {
    }

    public static String getSessionToken() {
        return m_session_token;
    }

    public static boolean isSessionTokenUnset() {
        return m_session_token.equals("");
    }

    public static boolean isSessionTokenExpired() {
        return m_session_token.equals(EXPIRED_TOKEN);
    }

    public static void setSessionTokenExpired() {
        m_session_token = EXPIRED_TOKEN;
    }

    public static void setSessionToken(Document d) {
        String s = d.getElementsByTagName("SessionToken").item(0).getChildNodes().item(0).getNodeValue();
        TokenManager.setToken(s);
    }

    public static void setSessionToken(String token) {
        TokenManager.setToken(token);
    }

    private static void setToken(String s) {
        if (s == null || s.length() == 0) {
            Logging.e(LOG_TAG, "Attempt to set session token to null or empty, ignored.");
            return;
        }
        m_session_token = s;
        sessionTokenHistory.add(new SessionTokenHistory(SessionTokenHistory.TypeSessionTokenHistory.SessionToken, s));
    }

    public static String getAccessToken() {
        return m_access_token;
    }

    public static void setAccessToken(String accessToken) {
        m_access_token = accessToken;
    }

    public static boolean isAccessTokenUnset() {
        return m_access_token.equals("");
    }

    public static boolean isAccessTokenExpired() {
        return m_access_token.equals(EXPIRED_TOKEN);
    }

    public static void setAccessTokenExpired() {
        m_access_token = EXPIRED_TOKEN;
    }

    public static void setRefreshToken(String refreshToken) {
        m_refresh_token = refreshToken;
    }

    public static String getRefreshToken() {
        return m_refresh_token;
    }

    public static boolean isRefreshTokenUnset() {
        return m_refresh_token.equals("");
    }

    public static boolean isRefreshTokenExpired() {
        return m_refresh_token.equals(EXPIRED_TOKEN);
    }

    public static void setRefrshTokenExpired() {
        m_refresh_token = EXPIRED_TOKEN;
    }

    public static void clearAllTokens() {
        m_session_token = "";
        m_access_token = "";
        m_refresh_token = "";
    }

    private static class SessionTokenHistory {
        public TypeSessionTokenHistory tokenType;
        public String tokenValue;
        public long tokenTime;

        public SessionTokenHistory(TypeSessionTokenHistory t, String s) {
            this.tokenType = t;
            this.tokenValue = s;
            this.tokenTime = System.currentTimeMillis();
        }

        public String getTime() {
            long now = System.currentTimeMillis();
            long dt = now - this.tokenTime;
            return Long.toString(dt / 1000L) + " sec ago";
        }

        public static enum TypeSessionTokenHistory {
            Login,
            SessionToken;

        }
    }
}

