/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.app;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Dialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Process;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.View;
import android.view.accessibility.AccessibilityManager;
import com.paypal.android.instrumentation.base.Logging;
import com.paypal.android.instrumentation.base.commons.app.AppStatusService;
import com.paypal.android.instrumentation.base.commons.validation.Assert;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class PPAppStatusService
implements AppStatusService {
    private static final String LOG_TAG = "PPAppStatusService";
    protected final Context _context;
    private final String _googlePlayUrl;
    private final List<AppStatusService.ActivityLifecycleCallbacks> _activityLifecycleCallbacks;
    private final List<AppStatusService.AppLifecycleListener> _appLifecycleListeners;
    private Activity _activeScreen;
    private boolean _appMustUpgrade = false;
    private String _api_server = "Live";
    public static final String FAKE_SERVER = "Fake";
    private String _version;
    private int _versionCode;
    private boolean _debug;

    public PPAppStatusService(Context context, String googlePlayUrl) {
        this._context = context;
        this._googlePlayUrl = googlePlayUrl;
        this._activityLifecycleCallbacks = new CopyOnWriteArrayList<AppStatusService.ActivityLifecycleCallbacks>();
        this._appLifecycleListeners = new CopyOnWriteArrayList<AppStatusService.AppLifecycleListener>();
        this.initInfo();
    }

    private void initInfo() {
        PackageManager m = this._context.getPackageManager();
        try {
            PackageInfo i = m.getPackageInfo(this._context.getPackageName(), 0);
            this._version = i.versionName;
            this._versionCode = i.versionCode;
            boolean bl = this._debug = (i.applicationInfo.flags & 2) != 0;
            if (this._debug) {
                Logging.enableLogging();
            }
        }
        catch (Exception e) {
            Logging.e(Logging.LOG_PREFIX, e.getMessage());
        }
    }

    @Override
    public void setAPIServer(String apiServer) {
        Assert.Argument.isNotNull("apiServer", apiServer);
        this._api_server = apiServer;
    }

    @Override
    public String getAPIServer() {
        return this._api_server;
    }

    @Override
    public boolean isDebugVersion() {
        return this._debug;
    }

    @Override
    public boolean isFakeServerEnabled() {
        return FAKE_SERVER.equalsIgnoreCase(this._api_server);
    }

    @Override
    public void setActiveScreen(Activity activeScreen) {
        this._activeScreen = activeScreen;
    }

    @Override
    public Activity getActiveScreen() {
        return this._activeScreen;
    }

    @Override
    public void removeActiveScreen() {
        this._activeScreen = null;
    }

    @Override
    public boolean isAppUpdateRequired() {
        return this._appMustUpgrade;
    }

    @Override
    public boolean isTalkbackEnabled() {
        AccessibilityManager am = (AccessibilityManager)this._context.getSystemService("accessibility");
        return am.isEnabled();
    }

    @Override
    public void setIsAppUpdateRequired(boolean updateRequired) {
        this._appMustUpgrade = updateRequired;
    }

    @Override
    public boolean isApplicationBroughtToBackground() {
        ComponentName topActivity;
        ActivityManager am = (ActivityManager)this._context.getSystemService("activity");
        List tasks = am.getRunningTasks(1);
        return !tasks.isEmpty() && !(topActivity = ((ActivityManager.RunningTaskInfo)tasks.get((int)0)).topActivity).getPackageName().equals(this._context.getPackageName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActivityLifecycleCallbacks(AppStatusService.ActivityLifecycleCallbacks callback) {
        List<AppStatusService.ActivityLifecycleCallbacks> list = this._activityLifecycleCallbacks;
        synchronized (list) {
            if (!this._activityLifecycleCallbacks.contains(callback)) {
                this._activityLifecycleCallbacks.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActivityLifecycleCallbacks(AppStatusService.ActivityLifecycleCallbacks callback) {
        List<AppStatusService.ActivityLifecycleCallbacks> list = this._activityLifecycleCallbacks;
        synchronized (list) {
            this._activityLifecycleCallbacks.remove(callback);
        }
    }

    @Override
    public boolean isRunningOnTablet() {
        return false;
    }

    @Override
    public String getAppVersionCode() {
        return String.valueOf(this._versionCode);
    }

    @Override
    public String getVersionName() {
        return this._version;
    }

    @Override
    public void dispatchLoginEvent() {
        List<AppStatusService.AppLifecycleListener> callbacks = Collections.unmodifiableList(this._appLifecycleListeners);
        for (AppStatusService.AppLifecycleListener appLifecycleListener : callbacks) {
            appLifecycleListener.onLogin();
        }
    }

    @Override
    public void dispatchLogoutEvent() {
        List<AppStatusService.AppLifecycleListener> callbacks = Collections.unmodifiableList(this._appLifecycleListeners);
        for (AppStatusService.AppLifecycleListener appLifecycleListener : callbacks) {
            appLifecycleListener.onLogout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAppLifecycleListener(AppStatusService.AppLifecycleListener appLifecycleListener) {
        List<AppStatusService.AppLifecycleListener> list = this._appLifecycleListeners;
        synchronized (list) {
            this._appLifecycleListeners.add(appLifecycleListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAppLifecycleListener(AppStatusService.AppLifecycleListener appLifecycleListener) {
        List<AppStatusService.AppLifecycleListener> list = this._appLifecycleListeners;
        synchronized (list) {
            this._appLifecycleListeners.remove(appLifecycleListener);
        }
    }

    @Override
    public void dispatchActivityCreated(Activity activity, Bundle savedInstanceState) {
        List<AppStatusService.ActivityLifecycleCallbacks> callbacks = Collections.unmodifiableList(this._activityLifecycleCallbacks);
        for (AppStatusService.ActivityLifecycleCallbacks activityLifecycleCallback : callbacks) {
            activityLifecycleCallback.onActivityCreated(activity, savedInstanceState);
        }
    }

    @Override
    public void dispatchActivityStarted(Activity activity) {
        List<AppStatusService.ActivityLifecycleCallbacks> callbacks = Collections.unmodifiableList(this._activityLifecycleCallbacks);
        for (AppStatusService.ActivityLifecycleCallbacks activityLifecycleCallback : callbacks) {
            activityLifecycleCallback.onActivityStarted(activity);
        }
    }

    @Override
    public void dispatchActivityResumed(Activity activity) {
        List<AppStatusService.ActivityLifecycleCallbacks> callbacks = Collections.unmodifiableList(this._activityLifecycleCallbacks);
        for (AppStatusService.ActivityLifecycleCallbacks activityLifecycleCallback : callbacks) {
            activityLifecycleCallback.onActivityResumed(activity);
        }
    }

    @Override
    public void dispatchActivityPaused(Activity activity) {
        List<AppStatusService.ActivityLifecycleCallbacks> callbacks = Collections.unmodifiableList(this._activityLifecycleCallbacks);
        for (AppStatusService.ActivityLifecycleCallbacks activityLifecycleCallback : callbacks) {
            activityLifecycleCallback.onActivityPaused(activity);
        }
    }

    @Override
    public void dispatchActivityStopped(Activity activity) {
        List<AppStatusService.ActivityLifecycleCallbacks> callbacks = Collections.unmodifiableList(this._activityLifecycleCallbacks);
        for (AppStatusService.ActivityLifecycleCallbacks activityLifecycleCallback : callbacks) {
            activityLifecycleCallback.onActivityStopped(activity);
        }
    }

    @Override
    public void dispatchActivitySaveInstanceState(Activity activity, Bundle outState) {
        List<AppStatusService.ActivityLifecycleCallbacks> callbacks = Collections.unmodifiableList(this._activityLifecycleCallbacks);
        for (AppStatusService.ActivityLifecycleCallbacks activityLifecycleCallback : callbacks) {
            activityLifecycleCallback.onActivitySaveInstanceState(activity, outState);
        }
    }

    @Override
    public void dispatchFragmentResumed(Fragment fragment) {
        List<AppStatusService.ActivityLifecycleCallbacks> callbacks = Collections.unmodifiableList(this._activityLifecycleCallbacks);
        for (AppStatusService.ActivityLifecycleCallbacks activityLifecycleCallback : callbacks) {
            activityLifecycleCallback.onFragmentResumed(fragment);
        }
    }

    @Override
    public void dispatchOnViewClicked(View view) {
        List<AppStatusService.ActivityLifecycleCallbacks> callbacks = Collections.unmodifiableList(this._activityLifecycleCallbacks);
        for (AppStatusService.ActivityLifecycleCallbacks activityLifecycleCallback : callbacks) {
            activityLifecycleCallback.onViewClicked(view);
        }
    }

    @Override
    public void dispatchOnViewClicked(int id) {
        List<AppStatusService.ActivityLifecycleCallbacks> callbacks = Collections.unmodifiableList(this._activityLifecycleCallbacks);
        for (AppStatusService.ActivityLifecycleCallbacks activityLifecycleCallback : callbacks) {
            activityLifecycleCallback.onViewClicked(id);
        }
    }

    @Override
    public void dispatchOnViewLongClicked(View view) {
        List<AppStatusService.ActivityLifecycleCallbacks> callbacks = Collections.unmodifiableList(this._activityLifecycleCallbacks);
        for (AppStatusService.ActivityLifecycleCallbacks activityLifecycleCallback : callbacks) {
            activityLifecycleCallback.onViewLongClicked(view);
        }
    }

    @Override
    public void dispatchOnDialogShown(Dialog dialog) {
        List<AppStatusService.ActivityLifecycleCallbacks> callbacks = Collections.unmodifiableList(this._activityLifecycleCallbacks);
        for (AppStatusService.ActivityLifecycleCallbacks activityLifecycleCallback : callbacks) {
            activityLifecycleCallback.onDialogShown(dialog);
        }
    }

    @Override
    public void dispatchActivityDestroyed(Activity activity) {
        List<AppStatusService.ActivityLifecycleCallbacks> callbacks = Collections.unmodifiableList(this._activityLifecycleCallbacks);
        for (AppStatusService.ActivityLifecycleCallbacks activityLifecycleCallback : callbacks) {
            activityLifecycleCallback.onActivityDestroyed(activity);
        }
    }

    @Override
    public void goToGooglePlay() {
        this.goToGooglePlay(this.getActiveScreen());
    }

    @Override
    public void goToGooglePlay(Activity caller) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)this._googlePlayUrl));
        caller.startActivity(intent);
    }

    @Override
    public void killMyApp() {
        try {
            Process.killProcess((int)Process.myPid());
        }
        catch (Exception ex) {
            Log.e((String)LOG_TAG, (String)("killProcess threw an exception: " + ex.getMessage()));
        }
    }

    @Override
    public void goToSite(String url) {
        Activity a = this.getActiveScreen();
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        a.startActivity(intent);
    }

    @Override
    public void goToSite(Uri uri) {
        Activity a = this.getActiveScreen();
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        a.startActivity(intent);
    }

    @Override
    public boolean isDemoMode() {
        return false;
    }
}

