/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.app;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.paypal.android.instrumentation.base.commons.app.ResourceService;
import com.paypal.android.instrumentation.base.domain.Country;
import com.paypal.android.instrumentation.base.util.StringUtils;
import java.util.Locale;

public class PPResourceService
implements ResourceService {
    private final Context _context;
    private final Resources _resources;

    public PPResourceService(Context context) {
        this._context = context;
        this._resources = this._context.getResources();
    }

    @Override
    public String getString(int id) {
        return this._resources.getString(id);
    }

    @Override
    public String getCountrySpecificString(int id, Country country) {
        Configuration configuration = this._resources.getConfiguration();
        Locale originalLocale = configuration.locale;
        configuration.locale = country.getLocale();
        DisplayMetrics metrics = new DisplayMetrics();
        ((WindowManager)this._context.getSystemService("window")).getDefaultDisplay().getMetrics(metrics);
        this._resources.updateConfiguration(configuration, metrics);
        String localizedString = this._resources.getString(id);
        configuration.locale = originalLocale;
        this._resources.updateConfiguration(configuration, metrics);
        return StringUtils.defaultIfEmpty(localizedString, this._resources.getString(id));
    }

    @Override
    public int getColor(int id) {
        return this._resources.getColor(id);
    }

    @Override
    public Drawable getDrawable(int id) {
        return this._resources.getDrawable(id);
    }
}

