/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.context;

import com.paypal.android.instrumentation.base.commons.dao.GenericEntity;
import java.io.Serializable;

public class ContextVariable
implements GenericEntity<VariableId> {
    private VariableId _id;
    private Object _value;
    public static final ContextVariable UNDEFINED = new ContextVariable(null){

        @Override
        public <T> void setValue(T value) {
            throw new UnsupportedOperationException("cant set value of undefined context variable");
        }

        @Override
        public <T> T getValue() {
            throw new IllegalStateException("value is absent");
        }
    };

    public ContextVariable(VariableId id) {
        this._id = id;
    }

    public <T> T getValue() {
        return (T)this._value;
    }

    public <T> void setValue(T value) {
        if (value.getClass().equals(this._id._type)) {
            this._value = value;
        }
    }

    @Override
    public VariableId getId() {
        return this._id;
    }

    public boolean hasValue() {
        return this._value != null;
    }

    public static class VariableId
    implements Serializable {
        private String _id;
        private Class<? extends Serializable> _type;

        public VariableId(String id, Class<? extends Serializable> type) {
            this._id = id;
            this._type = type;
        }

        public Class<? extends Serializable> getType() {
            return this._type;
        }

        public String getId() {
            return this._id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VariableId that = (VariableId)o;
            if (!this._id.equals(that._id)) {
                return false;
            }
            return this._type.equals(that._type);
        }

        public int hashCode() {
            int result = this._id.hashCode();
            result = 31 * result + this._type.hashCode();
            return result;
        }
    }
}

