/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.context;

import android.content.Context;
import com.paypal.android.instrumentation.base.commons.context.ContextVariable;
import com.paypal.android.instrumentation.base.commons.context.ContextVariableRepository;
import com.paypal.android.instrumentation.base.commons.lang.Optional;
import com.paypal.android.instrumentation.base.util.SharedPreferenceUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SharedPrefVariableRepository
extends ContextVariableRepository {
    private final Context _context;

    public SharedPrefVariableRepository(Context context) {
        this._context = context;
    }

    @Override
    public void save(ContextVariable entity) {
        ContextVariable.VariableId variableId = entity.getId();
        Class<? extends Serializable> type = variableId.getType();
        String id = variableId.getId();
        if (type.equals(Integer.class)) {
            SharedPreferenceUtil.setPreference(this._context, id, ((Integer)entity.getValue()).toString());
        } else if (type.equals(String.class)) {
            SharedPreferenceUtil.setPreference(this._context, id, (String)entity.getValue());
        } else if (type.equals(Boolean.class)) {
            SharedPreferenceUtil.setPreference(this._context, id, ((Boolean)entity.getValue()).toString());
        } else if (type.equals(HashSet.class)) {
            SharedPreferenceUtil.setPreference(this._context, id, (Set)entity.getValue());
        }
    }

    @Override
    public Optional<ContextVariable> getBy(ContextVariable.VariableId id) {
        ContextVariable variable = new ContextVariable(id);
        Class<? extends Serializable> type = id.getType();
        String varId = id.getId();
        if (type.equals(HashSet.class)) {
            HashSet value = (HashSet)SharedPreferenceUtil.getStringSetPreference(this._context, varId);
            if (value == null) {
                return Optional.absent();
            }
            variable.setValue(value);
            return Optional.of(variable);
        }
        String value = SharedPreferenceUtil.getStringPreference(this._context, varId, null);
        if (value == null) {
            return Optional.absent();
        }
        if (type.equals(Integer.class)) {
            variable.setValue(Integer.valueOf(value));
        } else if (type.equals(String.class)) {
            variable.setValue(value);
        } else if (type.equals(Boolean.class)) {
            variable.setValue(Boolean.valueOf(value));
        }
        return Optional.of(variable);
    }

    @Override
    public List<ContextVariable> getAll() {
        return Collections.emptyList();
    }

    @Override
    public void removeBy(ContextVariable.VariableId id) {
    }
}

