/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.dao;

import android.util.Log;
import com.paypal.android.instrumentation.base.commons.dao.GenericEntity;
import com.paypal.android.instrumentation.base.commons.dao.IRepository;
import com.paypal.android.instrumentation.base.commons.lang.Optional;
import com.paypal.android.instrumentation.base.commons.validation.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class GenericRepository<TEntity extends GenericEntity<TId>, TId extends Serializable>
implements IRepository<TEntity, TId> {
    protected final String LOG_TAG = GenericRepository.class.getSimpleName();
    protected final Map<TId, TEntity> _entities = new HashMap<TId, TEntity>();

    @Override
    public void save(TEntity entity) {
        Log.i((String)this.LOG_TAG, (String)("Saving entity: " + entity.getId().toString()));
        Assert.Argument.isNotNull("entity", entity);
        Assert.State.isValid(entity.getId() != null);
        Optional<TEntity> existingModule = this.getBy(entity.getId());
        if (existingModule.hasValue()) {
            Log.i((String)this.LOG_TAG, (String)("Remove existing entity: " + entity.getId().toString()));
            this._entities.remove(existingModule.getValue());
        }
        Log.i((String)this.LOG_TAG, (String)("Adding entity: " + entity.getId()));
        this._entities.put(entity.getId(), entity);
    }

    @Override
    public Optional<TEntity> getBy(TId id) {
        if (id == null || "".equals(id.toString()) || !this._entities.containsKey(id)) {
            return Optional.absent();
        }
        return Optional.of(this._entities.get(id));
    }

    @Override
    public void saveAll(List<TEntity> entities) {
        for (GenericEntity entity : entities) {
            this._entities.put(entity.getId(), entity);
        }
    }

    @Override
    public void removeBy(TId id) {
        if (id == null) {
            return;
        }
        if (this._entities.containsKey(id)) {
            this._entities.remove(id);
        }
    }

    @Override
    public void removeAll() {
        this._entities.clear();
    }

    @Override
    public List<TEntity> getAll() {
        return new ArrayList<TEntity>(this._entities.values());
    }
}

