/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.dao;

import com.paypal.android.instrumentation.base.Logging;
import com.paypal.android.instrumentation.base.commons.dao.IRepository;
import com.paypal.android.instrumentation.base.commons.dao.RepoModifiedEvent;
import com.paypal.android.instrumentation.base.commons.lang.Action;
import com.paypal.android.instrumentation.base.commons.lang.Optional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

public abstract class RepositoryImpl<TEntity, TId extends Serializable>
implements IRepository<TEntity, TId> {
    protected final String LOG_TAG = RepositoryImpl.class.getSimpleName();
    protected final Map<TId, TEntity> _entities = new HashMap<TId, TEntity>();
    private final Action<TId, TEntity> _idResolver;
    protected final Subject<RepoModifiedEvent<TEntity>, RepoModifiedEvent<TEntity>> _repoModifiedEvent = new SerializedSubject((Subject)PublishSubject.create());

    public RepositoryImpl(Action<TId, TEntity> idResolver) {
        this._idResolver = idResolver;
    }

    @Override
    public Observable<RepoModifiedEvent<TEntity>> getRepoModifiedObservable() {
        return this._repoModifiedEvent;
    }

    protected void emitDirtyEvent(RepoModifiedEvent event) {
        this._repoModifiedEvent.onNext((Object)event);
    }

    protected void onRepoModified(TEntity entity, Integer type) {
        this.emitDirtyEvent(new RepoModifiedEvent<TEntity>(entity, type));
    }

    @Override
    public void save(TEntity entity) {
        Serializable id = (Serializable)this._idResolver.invoke(entity);
        if (entity == null || id == null) {
            return;
        }
        Logging.i(this.LOG_TAG, "Saving entity: " + id.toString());
        Optional<TEntity> existingModule = this.getBy(id);
        if (existingModule.hasValue()) {
            Logging.i(this.LOG_TAG, "Remove existing entity: " + id.toString());
            this.onRepoModified(entity, 1);
        } else {
            this.onRepoModified(entity, 0);
        }
        Logging.i(this.LOG_TAG, "Adding entity: " + id);
        this._entities.put(id, entity);
    }

    @Override
    public Optional<TEntity> getBy(TId id) {
        if (id == null || "".equals(id.toString()) || !this._entities.containsKey(id)) {
            return Optional.absent();
        }
        return Optional.of(this._entities.get(id));
    }

    @Override
    public void saveAll(List<TEntity> entities) {
        if (entities == null) {
            return;
        }
        for (TEntity entity : entities) {
            this._entities.put(this._idResolver.invoke(entity), entity);
        }
    }

    @Override
    public void update(TId id) {
        Optional<TEntity> entityOptional = this.getBy(id);
        if (entityOptional.hasValue()) {
            this.save(entityOptional.getValue());
        }
    }

    @Override
    public void removeBy(TId id) {
        if (id == null) {
            return;
        }
        if (this._entities.containsKey(id)) {
            TEntity entity = this._entities.get(id);
            this._entities.remove(id);
            this.onRepoModified(entity, 2);
        }
    }

    @Override
    public void remove(TEntity entity) {
        this.removeBy((Serializable)this._idResolver.invoke(entity));
    }

    @Override
    public void removeAll() {
        this._entities.clear();
    }

    @Override
    public List<TEntity> getAll() {
        return new ArrayList<TEntity>(this._entities.values());
    }
}

