/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.lang;

import com.paypal.android.instrumentation.base.commons.validation.Assert;
import java.io.Serializable;

public class Optional<T>
implements Serializable {
    private final T _value;

    private Optional() {
        this._value = null;
    }

    protected Optional(T value) {
        Assert.Argument.isNotNull("value", value);
        this._value = value;
    }

    public static <T> Optional<T> of(T value) {
        return value == null ? Optional.absent() : new Optional<T>(value);
    }

    public static <T> Optional<T> absent() {
        return Absent.INSTANCE;
    }

    public boolean hasValue() {
        return this._value != null;
    }

    public T getValue() {
        return this._value;
    }

    private static final class Absent
    extends Optional<Object> {
        private static final Absent INSTANCE = new Absent();

        private Absent() {
        }

        @Override
        public boolean hasValue() {
            return false;
        }

        @Override
        public Object getValue() {
            throw new IllegalStateException("value is absent");
        }
    }
}

