/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.patterns.events;

import com.paypal.android.instrumentation.base.commons.patterns.events.Event;
import com.paypal.android.instrumentation.base.commons.patterns.events.EventListener;
import com.paypal.android.instrumentation.base.commons.validation.Assert;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractEventManager<T extends EventListener, S extends Event> {
    private final List<T> _listeners = new ArrayList<T>();

    protected void addEventListener(T listener) {
        Assert.Argument.isNotNull("listener", listener);
        this._listeners.add(listener);
    }

    protected void removeEventListener(T listener) {
        Assert.Argument.isNotNull("listener", listener);
        if (this._listeners.contains(listener)) {
            this._listeners.remove(listener);
        }
    }

    protected void fireEvent(S event) {
        Assert.Argument.isNotNull("event", event);
        if (this._listeners != null) {
            for (EventListener listener : this._listeners) {
                this.doFireEvent(listener, event);
            }
        }
    }

    protected abstract void doFireEvent(T var1, S var2);
}

