/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.patterns.mediator;

import com.paypal.android.instrumentation.base.commons.patterns.events.AbstractEventManager;
import com.paypal.android.instrumentation.base.commons.patterns.events.EventType;
import com.paypal.android.instrumentation.base.commons.patterns.mediator.Colleague;
import com.paypal.android.instrumentation.base.commons.patterns.mediator.MediatorEvent;
import java.util.HashMap;
import java.util.Map;

public class Mediator {
    private Map<EventType, MediatorEventManager> _mapMessages = new HashMap<EventType, MediatorEventManager>();

    private Mediator() {
    }

    public static Mediator getInstance() {
        return Lazy.INSTANCE;
    }

    public void notifyColleagues(EventType message, Object args) {
        if (this._mapMessages.containsKey(message)) {
            MediatorEvent<EventType> mediatorMessage = new MediatorEvent<EventType>((Object)this, message, args);
            MediatorEventManager manager = this._mapMessages.get(message);
            manager.notifyListeners(mediatorMessage);
        }
    }

    public void register(EventType message, Colleague colleague) {
        if (this._mapMessages.get(message) == null) {
            MediatorEventManager manager = new MediatorEventManager();
            manager.addMediatorEventListener(colleague);
            this._mapMessages.put(message, manager);
        } else {
            MediatorEventManager manager = this._mapMessages.get(message);
            manager.addMediatorEventListener(colleague);
        }
    }

    public void unregister(String message, Colleague colleague) {
        MediatorEventManager manager = this._mapMessages.get(message);
        manager.removeMediatorEventListener(colleague);
    }

    private class MediatorEventManager
    extends AbstractEventManager<Colleague, MediatorEvent> {
        private MediatorEventManager() {
        }

        public void notifyListeners(MediatorEvent event) {
            this.fireEvent(event);
        }

        public void addMediatorEventListener(Colleague listener) {
            this.addEventListener(listener);
        }

        public void removeMediatorEventListener(Colleague listener) {
            this.removeEventListener(listener);
        }

        @Override
        protected void doFireEvent(Colleague listener, MediatorEvent event) {
            listener.processMessage(event);
        }
    }

    private static class Lazy {
        public static final Mediator INSTANCE = new Mediator();

        private Lazy() {
        }
    }
}

