/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.patterns.mvc;

import android.content.Context;
import android.view.View;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.IBindingModel;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.ModelEventListener;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.presenter.IPresenter;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.view.AbstractView;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.view.BindingView;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.view.DefaultView;
import com.paypal.android.instrumentation.base.commons.ui.factories.LayoutFactory;
import com.paypal.android.instrumentation.base.commons.validation.Assert;

public class MVPFactory {
    public static <T extends BindingView> View hookupMVP(Context context, IBindingModel model, IPresenter presenter, T view) {
        Assert.Argument.isNotNull("context", context);
        Assert.Argument.isNotNull("model", model);
        Assert.Argument.isNotNull("presenter", presenter);
        Assert.Argument.isNotNull("view", view);
        model.removeListener(view);
        LayoutFactory layoutFactory = new LayoutFactory(model, presenter);
        presenter.initComponents();
        model.addListener(presenter);
        view.setViewListener(presenter);
        view.setModel(model);
        view.initialize(context, layoutFactory);
        presenter.onViewInitialized();
        return view.getView();
    }

    public static <T extends BindingView> void hookupMVP(Context context, IBindingModel model, IPresenter presenter, T ... view) {
        Assert.Argument.isNotNull("context", context);
        Assert.Argument.isNotNull("model", model);
        Assert.Argument.isNotNull("presenter", presenter);
        Assert.Argument.isNotNull("view", view);
        LayoutFactory layoutFactory = new LayoutFactory(model, presenter);
        presenter.initComponents();
        model.addListener(presenter);
        for (int i = 0; i < view.length; ++i) {
            model.removeListener((ModelEventListener)view[i]);
            ((AbstractView)view[i]).setViewListener(presenter);
            ((AbstractView)view[i]).setModel(model);
            ((DefaultView)view[i]).initialize(context, layoutFactory);
        }
        presenter.onViewInitialized();
    }
}

