/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.patterns.mvc.binding;

import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.DataContext;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.PropertyChangeEvent;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.PropertyChangeListener;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.ModelChangeEvent;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.ModelEventListener;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.ModelEventType;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.PropertyKeys;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.PropertyValueConverter;

public class Binding<T>
implements ModelEventListener {
    private final PropertyKeys _bindingProperty;
    private final DataContext _bindingSource;
    private final PropertyChangeListener _bindingTarget;
    private final PropertyValueConverter _valueConverter;

    public Binding(PropertyKeys property, DataContext dataContext, PropertyChangeListener bindingTarget, PropertyValueConverter valueConverter) {
        this._bindingProperty = property;
        this._bindingSource = dataContext;
        this._bindingTarget = bindingTarget;
        this._valueConverter = valueConverter;
        this._bindingSource.addListener(property, this);
    }

    public Binding(PropertyKeys property, DataContext dataContext, PropertyChangeListener bindingTarget) {
        this._bindingProperty = property;
        this._bindingSource = dataContext;
        this._bindingTarget = bindingTarget;
        this._valueConverter = null;
        this._bindingSource.addListener(property, this);
    }

    public void initBinding() {
        if (this._bindingSource.containsValue(this._bindingProperty)) {
            Object value = this._bindingSource.getValue(this._bindingProperty);
            PropertyChangeEvent newEvent = new PropertyChangeEvent((Object)this._bindingSource, this._bindingProperty, null, this._valueConverter == null ? value : this._valueConverter.convertSource(value), ModelEventType.CHANGED, this);
            this._bindingTarget.propertyChanged(newEvent);
        }
    }

    public PropertyKeys getProperty() {
        return this._bindingProperty;
    }

    @Override
    public void modelChanged(ModelChangeEvent event) {
        if (event.source.equals(this)) {
            return;
        }
        if (((ModelEventType)event.type).equals(ModelEventType.CHANGED) && event.propertyKey.equals(this._bindingProperty)) {
            PropertyChangeEvent newEvent = new PropertyChangeEvent((Object)this._bindingSource, this._bindingProperty, null, this._valueConverter == null ? event.newValue : this._valueConverter.convertSource(event.newValue), ModelEventType.CHANGED, this);
            this._bindingTarget.propertyChanged(newEvent);
        }
    }

    public void notifyTargetUpdated(T value) {
        if (this._bindingSource.isValueChanged(this._bindingProperty, value)) {
            this.updateSource(value);
        }
    }

    public void notifyTargetUpdated(T value, boolean forceUpdate) {
        if (this._bindingSource.isValueChanged(this._bindingProperty, value) || forceUpdate) {
            this.updateSource(value);
        }
    }

    public <T> T getDataSourceValue() {
        return this._bindingSource.getValue(this._bindingProperty);
    }

    private void updateSource(T value) {
        if (this._valueConverter == null) {
            this._bindingSource.setValue(this._bindingProperty, value, this);
        } else {
            Object convertedValue = this._valueConverter.convertTarget(value);
            this._bindingSource.setValue(this._bindingProperty, convertedValue, this);
        }
    }

    static enum Type {
        OneWay,
        TwoWay;

    }
}

