/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.patterns.mvc.commands;

import com.paypal.android.instrumentation.base.commons.lang.Optional;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.annotations.CommandType;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.commands.ClickFactory;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.commands.CommandFactory;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.commands.LongClickFactory;
import com.paypal.android.instrumentation.base.commons.validation.Assert;
import java.util.HashMap;
import java.util.Map;

public class CommandFactoryMapper {
    private static final Map<CommandType, CommandFactory> FACTORY_MAP = new HashMap<CommandType, CommandFactory>();

    public static void registerFactory(CommandType commandType, CommandFactory commandFactory) {
        Assert.Argument.isNotNull("CommandType", (Object)commandType);
        Assert.Argument.isNotNull("commandFactory", commandFactory);
        FACTORY_MAP.put(commandType, commandFactory);
    }

    public static Optional<? extends CommandFactory> getFactory(CommandType type) {
        if (FACTORY_MAP.containsKey((Object)type)) {
            return Optional.of(FACTORY_MAP.get((Object)type));
        }
        return Optional.absent();
    }

    static {
        FACTORY_MAP.put(CommandType.CLICK, new ClickFactory());
        FACTORY_MAP.put(CommandType.LONG_CLICK, new LongClickFactory());
    }
}

