/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.patterns.mvc.commands;

import android.view.View;
import com.paypal.android.instrumentation.base.Logging;
import com.paypal.android.instrumentation.base.commons.app.AppStatusService;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.CommandContext;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.commands.CommandFactory;
import com.paypal.android.instrumentation.p2pmobile.R;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DispatchableClickFactory
implements CommandFactory {
    private final AppStatusService _appStatusService;

    public DispatchableClickFactory(AppStatusService appStatusService) {
        this._appStatusService = appStatusService;
    }

    public void setClickListener(View view, final View.OnClickListener delegate) {
        View.OnClickListener onClickListener = new View.OnClickListener(){
            View.OnClickListener _delegate;
            {
                this._delegate = delegate;
            }

            public void onClick(View v) {
                this._delegate.onClick(v);
                DispatchableClickFactory.this._appStatusService.dispatchOnViewClicked(v);
            }
        };
        view.setOnClickListener(onClickListener);
    }

    @Override
    public <T extends View> void handleCommand(final CommandContext commandContext, View view, final Method method) {
        View.OnClickListener onClickListener = new View.OnClickListener(){
            private final Class<?>[] _parameterTypes;
            {
                this._parameterTypes = method.getParameterTypes();
            }

            public void onClick(View v) {
                try {
                    Object tag = v.getTag(R.id.binding_value);
                    if (tag == null) {
                        tag = v.getTag();
                    }
                    if (this._parameterTypes.length > 0 && this._parameterTypes[0].isInstance(tag)) {
                        method.invoke((Object)commandContext, tag);
                    } else {
                        method.invoke((Object)commandContext, new Object[0]);
                    }
                    DispatchableClickFactory.this._appStatusService.dispatchOnViewClicked(v);
                }
                catch (IllegalAccessException e) {
                    Logging.e(Logging.LOG_PREFIX, e.getMessage());
                }
                catch (InvocationTargetException e) {
                    Logging.e(Logging.LOG_PREFIX, e.getTargetException().getMessage());
                }
            }
        };
        view.setOnClickListener(onClickListener);
    }
}

