/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.patterns.mvc.commands;

import android.view.View;
import com.paypal.android.instrumentation.base.Logging;
import com.paypal.android.instrumentation.base.commons.app.AppStatusService;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.CommandContext;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.commands.CommandFactory;
import com.paypal.android.instrumentation.p2pmobile.R;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DispatchableLongClickFactory
implements CommandFactory {
    private final AppStatusService _appStatusService;

    public DispatchableLongClickFactory(AppStatusService appStatusService) {
        this._appStatusService = appStatusService;
    }

    public void setOnLongClickListener(View view, final View.OnLongClickListener delegate) {
        View.OnLongClickListener onLongClickListener = new View.OnLongClickListener(){
            View.OnLongClickListener _delegate;
            {
                this._delegate = delegate;
            }

            public boolean onLongClick(View v) {
                this._delegate.onLongClick(v);
                DispatchableLongClickFactory.this._appStatusService.dispatchOnViewLongClicked(v);
                return true;
            }
        };
        view.setOnLongClickListener(onLongClickListener);
    }

    @Override
    public <T extends View> void handleCommand(final CommandContext commandContext, View view, final Method method) {
        View.OnLongClickListener onClickListener = new View.OnLongClickListener(){
            private final Class<?>[] _parameterTypes;
            {
                this._parameterTypes = method.getParameterTypes();
            }

            public boolean onLongClick(View v) {
                try {
                    Object tag = v.getTag(R.id.binding_value);
                    if (tag == null) {
                        tag = v.getTag();
                    }
                    if (this._parameterTypes.length > 0 && this._parameterTypes[0].isInstance(tag)) {
                        method.invoke((Object)commandContext, tag);
                    } else {
                        method.invoke((Object)commandContext, new Object[0]);
                    }
                    DispatchableLongClickFactory.this._appStatusService.dispatchOnViewLongClicked(v);
                }
                catch (IllegalAccessException e) {
                    Logging.e(Logging.LOG_PREFIX, e.getMessage());
                }
                catch (InvocationTargetException e) {
                    Logging.e(Logging.LOG_PREFIX, e.getMessage());
                }
                return true;
            }
        };
        view.setOnLongClickListener(onClickListener);
    }
}

