/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.patterns.mvc.model;

import com.paypal.android.instrumentation.base.commons.patterns.events.AbstractEventManager;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.IModel;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.ModelChangeEvent;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.ModelEventListener;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.PropertyKeys;
import com.paypal.android.instrumentation.base.commons.validation.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractModel
extends AbstractEventManager<ModelEventListener, ModelChangeEvent>
implements IModel {
    private final Map<PropertyKeys, List<ModelEventListener>> _propertyListeners = new HashMap<PropertyKeys, List<ModelEventListener>>();

    @Override
    public void addListener(PropertyKeys property, ModelEventListener listener) {
        this.addEventListener(property, listener);
    }

    private void addEventListener(PropertyKeys property, ModelEventListener listener) {
        Assert.Argument.isNotNull("listener", listener);
        Assert.Argument.isNotNull("property", property);
        if (this._propertyListeners.containsKey(property)) {
            List<ModelEventListener> listeners = this._propertyListeners.get(property);
            listeners.add(listener);
        } else {
            ArrayList<ModelEventListener> listeners = new ArrayList<ModelEventListener>();
            listeners.add(listener);
            this._propertyListeners.put(property, listeners);
        }
    }

    @Override
    public void removeListener(PropertyKeys property, ModelEventListener listener) {
        this.removeEventListener(property, listener);
    }

    private void removeEventListener(PropertyKeys property, ModelEventListener listener) {
        Assert.Argument.isNotNull("listener", listener);
        Assert.Argument.isNotNull("property", property);
        if (this._propertyListeners.containsKey(property)) {
            List<ModelEventListener> modelEventListeners = this._propertyListeners.get(property);
            modelEventListeners.remove(listener);
        }
    }

    @Override
    public void addListener(ModelEventListener listener) {
        this.addEventListener(listener);
    }

    @Override
    public void removeListener(ModelEventListener listener) {
        this.removeEventListener(listener);
    }

    @Override
    public void notifyListeners(ModelChangeEvent event) {
        PropertyKeys propertyKey = event.propertyKey;
        if (this._propertyListeners.containsKey(propertyKey)) {
            List<ModelEventListener> modelEventListeners = this._propertyListeners.get(propertyKey);
            for (ModelEventListener modelEventListener : modelEventListeners) {
                this.doFireEvent(modelEventListener, event);
            }
        }
        this.fireEvent(event);
    }

    @Override
    protected void doFireEvent(ModelEventListener listener, ModelChangeEvent event) {
        listener.modelChanged(event);
    }

    @Override
    public void modelReset() {
    }
}

