/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.patterns.mvc.model;

import com.paypal.android.instrumentation.base.Logging;
import com.paypal.android.instrumentation.base.commons.lang.Optional;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.DefaultModel;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.IBindingModel;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.Property;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.PropertyKeys;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.PropertyValueConverter;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.PropertyValueFormatter;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.ValidationResult;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.ValidationResults;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.ValidationRule;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.Validator;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.ValidatorProvider;
import com.paypal.android.instrumentation.base.commons.validation.Assert;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BindingModel
extends DefaultModel
implements IBindingModel {
    final Map<PropertyKeys, List<ValidationRule<?, ?>>> _validationMap = new HashMap();
    final List<Property> _properties = new ArrayList<Property>();
    private final Map<String, PropertyValueConverter> _converterMap = new HashMap<String, PropertyValueConverter>();
    private Map<String, PropertyValueFormatter> _formatterMap = new HashMap<String, PropertyValueFormatter>();

    public BindingModel() {
        this(true);
    }

    public BindingModel(boolean initBindingAndValidation) {
        if (initBindingAndValidation) {
            this.tryInitValidation();
        }
    }

    protected void tryInitValidation() {
        try {
            this.initValidation();
        }
        catch (IllegalAccessException e) {
            Logging.e(Logging.LOG_PREFIX, e.getMessage());
        }
    }

    private void initValidation() throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = this.getClass().getFields()) {
            Annotation[] annotations;
            if (!field.getType().isAssignableFrom(Property.class)) continue;
            field.setAccessible(true);
            Property property = (Property)field.get(this);
            if (property == null) {
                return;
            }
            this._properties.add(property);
            for (Annotation annotation : annotations = field.getAnnotations()) {
                Validator validator;
                Class<? extends ValidationRule<?, ?>> validatorClass;
                ValidationRule<?, ?> validationRule;
                Class<? extends Annotation> annotationClass = annotation.annotationType();
                if (!annotationClass.isAnnotationPresent(Validator.class) || (validationRule = ValidatorProvider.get(validatorClass = (validator = annotationClass.getAnnotation(Validator.class)).validatedBy(), annotation)) == null) continue;
                this.addValidationRule(property, validationRule);
            }
        }
    }

    @Override
    public <T> T setValue(PropertyKeys key, T newValue) {
        return this.setValue(key, newValue, this);
    }

    @Override
    public <T> T setValue(PropertyKeys key, T newValue, Object source) {
        ValidationResults validationResults = this.validateValue(key, newValue);
        if (validationResults.hasErrors()) {
            this.dispatchInvalidValue(key, newValue, validationResults);
            return newValue;
        }
        return super.setValue(key, newValue, source);
    }

    private <T> ValidationResults validateValue(PropertyKeys key, T newValue) {
        List<ValidationRule<?, ?>> validationRules = this.getValidationRule(key);
        ValidationResults results = new ValidationResults();
        if (validationRules.isEmpty()) {
            return results;
        }
        for (ValidationRule<?, ?> rule : validationRules) {
            if (!rule.validatesOnTargetUpdated()) continue;
            ValidationResult result = ValidationResult.forProperty(key);
            rule.validate(newValue, result);
            results.addResult(result);
        }
        return results;
    }

    private List<ValidationRule<?, ?>> getValidationRule(PropertyKeys key) {
        if (this._validationMap.containsKey(key)) {
            return this._validationMap.get(key);
        }
        return Collections.emptyList();
    }

    @Override
    public <T> boolean isValueChanged(PropertyKeys key, T newValue) {
        Object value = this.getValue(key);
        return value == null || !value.equals(newValue);
    }

    @Override
    public List<Property> getProperties() {
        return this._properties;
    }

    @Override
    public void addConverter(String converterName, PropertyValueConverter converter) {
        Assert.Argument.isNotNull("converterName", converterName);
        Assert.Argument.isNotNull("converter", converter);
        this._converterMap.put(converterName, converter);
    }

    @Override
    public void addConverter(PropertyValueConverter converter) {
        this.addConverter(converter.getClass().getSimpleName(), converter);
    }

    @Override
    public Optional<PropertyValueConverter> getPropertyConverter(String converterName) {
        return this._converterMap.containsKey(converterName) ? Optional.of(this._converterMap.get(converterName)) : Optional.absent();
    }

    @Override
    public void addFormatter(String formatterName, PropertyValueFormatter formatter) {
        Assert.Argument.isNotNull("converterName", formatterName);
        Assert.Argument.isNotNull("formatter", formatter);
        this._formatterMap.put(formatterName, formatter);
    }

    @Override
    public void addFormatter(PropertyValueFormatter formatter) {
        this.addFormatter(formatter.getClass().getSimpleName(), formatter);
    }

    @Override
    public Optional<PropertyValueFormatter> getPropertyFormatter(String formatterName) {
        return this._formatterMap.containsKey(formatterName) ? Optional.of(this._formatterMap.get(formatterName)) : Optional.absent();
    }

    @Override
    public ValidationResults validateModel() {
        ValidationResults results = new ValidationResults();
        for (PropertyKeys propertyKey : this._validationMap.keySet()) {
            ValidationResults propertyResults = new ValidationResults();
            List<ValidationRule<?, ?>> validationRules = this._validationMap.get(propertyKey);
            Object value = this.getValue(propertyKey);
            for (ValidationRule<?, ?> validationRule : validationRules) {
                ValidationResult result = ValidationResult.forProperty(propertyKey);
                validationRule.validate(value, result);
                propertyResults.addResult(result);
            }
            results.addResults(propertyResults);
        }
        return results;
    }

    @Override
    public ValidationResults validate(PropertyKeys property) {
        ValidationResults propertyResults = new ValidationResults();
        List<ValidationRule<?, ?>> validationRules = this._validationMap.get(property);
        Object value = this.getValue(property);
        for (ValidationRule<?, ?> validationRule : validationRules) {
            ValidationResult result = ValidationResult.forProperty(property);
            validationRule.validate(value, result);
            propertyResults.addResult(result);
        }
        return propertyResults;
    }

    @Override
    public void addValidationRule(PropertyKeys property, ValidationRule<?, ?> rule) {
        if (this._validationMap.containsKey(property)) {
            List<ValidationRule<?, ?>> validationRules = this._validationMap.get(property);
            validationRules.add(rule);
        } else {
            ArrayList validationRules = new ArrayList();
            validationRules.add(rule);
            this._validationMap.put(property, validationRules);
        }
    }
}

