/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.patterns.mvc.model;

import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.AbstractModel;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.ModelChangeEvent;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.ModelEventType;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.PropertyKeys;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.ValidationResults;
import com.paypal.android.instrumentation.base.commons.validation.Assert;
import java.util.HashMap;
import java.util.Map;

public class DefaultModel
extends AbstractModel {
    protected final Map<Object, Object> _attributes = new HashMap<Object, Object>();

    public <T> T getValue(String key, T defaultValue) {
        Object value = this._attributes.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    public <T> T getValue(String key) {
        return this.getValue(key, null);
    }

    public <T> T setValue(String key, T newValue) {
        Object oldValue = newValue == null ? this._attributes.remove(key) : this._attributes.put(key, newValue);
        ModelChangeEvent event = new ModelChangeEvent(this, key, oldValue, newValue, ModelEventType.CHANGED);
        this.notifyListeners(event);
        return (T)oldValue;
    }

    public <T> T getValue(PropertyKeys key, T defaultValue) {
        Object value = this._attributes.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    public <T> T getValue(PropertyKeys key) {
        return this.getValue(key, null);
    }

    public <T> T setValue(PropertyKeys key, T newValue) {
        return this.setValue(key, newValue, this);
    }

    public <T> T setValue(PropertyKeys key, T newValue, Object source) {
        Assert.Argument.isNotNull("key", key);
        Assert.Argument.isNotNull("source", source);
        Object oldValue = newValue == null ? this._attributes.remove(key) : this._attributes.put(key, newValue);
        ModelChangeEvent event = new ModelChangeEvent(source, key, oldValue, newValue, ModelEventType.CHANGED);
        this.notifyListeners(event);
        return (T)oldValue;
    }

    public boolean containsValue(PropertyKeys key) {
        return this._attributes.containsKey(key) && this._attributes.get(key) != null;
    }

    @Override
    public boolean isEmpty() {
        return this._attributes.isEmpty();
    }

    @Override
    public void modelReset() {
        this._attributes.clear();
        ModelChangeEvent event = new ModelChangeEvent((Object)this, ModelEventType.RESET);
        this.notifyListeners(event);
    }

    public void notifyPropertyChanged(PropertyKeys key) {
        Assert.Argument.isNotNull("key", key);
        Object value = this.getValue(key);
        ModelChangeEvent event = new ModelChangeEvent((Object)this, key, value, value, ModelEventType.CHANGED);
        this.notifyListeners(event);
    }

    protected void dispatchAction(PropertyKeys key) {
        ModelChangeEvent event = new ModelChangeEvent((Object)this, key, null, null, ModelEventType.ACTION);
        this.notifyListeners(event);
    }

    protected <T> T dispatchInvalidValue(PropertyKeys key, T newValue, ValidationResults results) {
        Object oldValue = this._attributes.get(key);
        ModelChangeEvent event = new ModelChangeEvent(this, key, results, oldValue, newValue, ModelEventType.INVALID);
        this.notifyListeners(event);
        return (T)oldValue;
    }
}

