/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.patterns.mvc.model;

import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.BindingModel;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.PropertyKeys;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.ValidationResults;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.ValidationRule;

public class Property<T>
implements PropertyKeys {
    private BindingModel _modelDelegate;
    private String _name;

    private Property() {
    }

    public Property(String name, BindingModel modelDelegate) {
        this._modelDelegate = modelDelegate;
        this._name = name;
    }

    private Property(String name) {
        this._name = name;
    }

    public static Property withName(String name) {
        return new Property(name);
    }

    public Property<T> withRule(ValidationRule<?, T> validation) {
        if (this._modelDelegate != null) {
            this._modelDelegate.addValidationRule(this, validation);
        }
        return this;
    }

    public void set(T newValue) {
        if (this._modelDelegate == null) {
            return;
        }
        this._modelDelegate.setValue(this, newValue);
    }

    public String name() {
        return this._name;
    }

    public boolean hasValue() {
        return this._modelDelegate.containsValue(this);
    }

    public boolean isValid() {
        if (this._modelDelegate == null) {
            return true;
        }
        ValidationResults validate = this._modelDelegate.validate(this);
        return !validate.hasErrors();
    }

    public T value() {
        if (this._modelDelegate == null) {
            return null;
        }
        return this._modelDelegate.getValue(this);
    }
}

