/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation;

import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.AbstractValidator;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.Equals;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.ValidationResult;
import com.paypal.android.instrumentation.base.util.StringUtils;

public class EqualsValidator
extends AbstractValidator<Equals, String> {
    private String _value;

    public EqualsValidator() {
    }

    public EqualsValidator(String value, String message, boolean validatesOnTargetUpdated) {
        this._value = value;
        this._message = message;
        this._validatesOnTargetUpdated = validatesOnTargetUpdated;
    }

    @Override
    public void initialize(Equals annotation) {
        this._message = annotation.message();
        this._validatesOnTargetUpdated = annotation.validatesOnTargetUpdated();
        this._messageID = annotation.messageID();
        this._value = annotation.value();
    }

    @Override
    public void validate(String propertyValue, ValidationResult result) {
        if (StringUtils.isEmpty(propertyValue)) {
            result.withStatus(false).withMessage(this._message).withMessageID(this._messageID);
            return;
        }
        boolean isValid = propertyValue.equals(this._value);
        result.withStatus(isValid).withMessage(this._message).withMessageID(this._messageID);
    }

    @Override
    public boolean validatesOnTargetUpdated() {
        return false;
    }
}

