/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation;

import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.AbstractValidator;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.Length;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.ValidationResult;
import com.paypal.android.instrumentation.base.util.StringUtils;

public class LengthValidator
extends AbstractValidator<Length, String> {
    private int _min;
    private int _max;
    private int _length;

    LengthValidator() {
    }

    public LengthValidator(int min, int max, String message, boolean validatesOnTargetUpdated) {
        this._min = min;
        this._max = max;
        this._message = message;
        this._validatesOnTargetUpdated = validatesOnTargetUpdated;
    }

    public LengthValidator(int length, String message, boolean validatesOnTargetUpdated) {
        this._length = length;
        this._message = message;
        this._validatesOnTargetUpdated = validatesOnTargetUpdated;
    }

    @Override
    public void initialize(Length annotation) {
        this._message = annotation.message();
        this._messageID = annotation.messageID();
        this._validatesOnTargetUpdated = annotation.validatesOnTargetUpdated();
        this._min = annotation.min();
        this._max = annotation.max();
        this._length = annotation.length();
    }

    @Override
    public void validate(String value, ValidationResult result) {
        boolean validateMin = this._min > 0;
        boolean validateMax = this._max > 0;
        boolean validateLength = this._length > 0;
        int length = StringUtils.isEmpty(value) ? 0 : value.length();
        boolean isValid = true;
        if (validateLength) {
            isValid = length == this._length;
        } else if (validateMax && validateMin) {
            isValid = length >= this._min && length <= this._max;
        } else if (validateMax) {
            isValid = length <= this._max;
        } else if (validateMin) {
            isValid = length >= this._min;
        }
        result.withStatus(isValid).withMessage(this._message).withMessageID(this._messageID);
    }
}

