/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation;

import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.AbstractValidator;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.Matches;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.ValidationResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MatchesValidator
extends AbstractValidator<Matches, String> {
    private Pattern _pattern;

    MatchesValidator() {
    }

    public MatchesValidator(String pattern, String message, boolean validatesOnTargetUpdated) {
        this._pattern = Pattern.compile(pattern);
        this._message = message;
        this._validatesOnTargetUpdated = validatesOnTargetUpdated;
    }

    @Override
    public void initialize(Matches annotation) {
        this._message = annotation.message();
        this._messageID = annotation.messageID();
        this._validatesOnTargetUpdated = annotation.validatesOnTargetUpdated();
        this._pattern = Pattern.compile(annotation.pattern());
    }

    @Override
    public void validate(String value, ValidationResult result) {
        Matcher matcher = this._pattern.matcher(value);
        boolean isValid = matcher.find();
        result.withStatus(isValid).withMessage(this._message).withMessageID(this._messageID);
    }
}

