/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation;

import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.Email;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.EmailValidator;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.Equals;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.EqualsValidator;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.Length;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.LengthValidator;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.Matches;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.MatchesValidator;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.NotEmpty;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.NotEmptyValidator;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.NotNull;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.NotNullValidator;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.validation.ValidationRule;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public class ValidatorProvider {
    private static Map<Class<? extends ValidationRule<?, ?>>, ValidatorFactory> s_factoryMap = new HashMap();

    public static <T extends Annotation> ValidationRule<?, ?> get(Class<? extends ValidationRule<?, ?>> validatorClass, T annotation) {
        if (s_factoryMap.containsKey(validatorClass)) {
            ValidatorFactory validatorFactory = s_factoryMap.get(validatorClass);
            return validatorFactory.create(annotation);
        }
        return null;
    }

    public static void registerValidator(Class<? extends ValidationRule<?, ?>> ruleClass, ValidatorFactory factory) {
        s_factoryMap.put(ruleClass, factory);
    }

    static {
        s_factoryMap.put(NotNullValidator.class, new NotNullFactory());
        s_factoryMap.put(EmailValidator.class, new EmailFactory());
        s_factoryMap.put(NotEmptyValidator.class, new NotEmptyFactory());
        s_factoryMap.put(LengthValidator.class, new LengthFactory());
        s_factoryMap.put(MatchesValidator.class, new MatchesFactory());
        s_factoryMap.put(EqualsValidator.class, new EqualsFactory());
    }

    private static class EqualsFactory
    implements ValidatorFactory<EqualsValidator> {
        private EqualsFactory() {
        }

        @Override
        public EqualsValidator create(Annotation annotation) {
            EqualsValidator validator = new EqualsValidator();
            if (annotation instanceof Equals) {
                validator.initialize((Equals)annotation);
            }
            return validator;
        }
    }

    private static class EmailFactory
    implements ValidatorFactory<EmailValidator> {
        private EmailFactory() {
        }

        @Override
        public EmailValidator create(Annotation annotation) {
            EmailValidator validator = new EmailValidator();
            if (annotation instanceof Email) {
                validator.initialize((Email)annotation);
            }
            return validator;
        }
    }

    private static class MatchesFactory
    implements ValidatorFactory<MatchesValidator> {
        private MatchesFactory() {
        }

        @Override
        public MatchesValidator create(Annotation annotation) {
            MatchesValidator validator = new MatchesValidator();
            if (annotation instanceof Matches) {
                validator.initialize((Matches)annotation);
            }
            return validator;
        }
    }

    private static class LengthFactory
    implements ValidatorFactory<LengthValidator> {
        private LengthFactory() {
        }

        @Override
        public LengthValidator create(Annotation annotation) {
            LengthValidator validator = new LengthValidator();
            if (annotation instanceof Length) {
                validator.initialize((Length)annotation);
            }
            return validator;
        }
    }

    private static class NotEmptyFactory
    implements ValidatorFactory<NotEmptyValidator> {
        private NotEmptyFactory() {
        }

        @Override
        public NotEmptyValidator create(Annotation annotation) {
            NotEmptyValidator validator = new NotEmptyValidator();
            if (annotation instanceof NotEmpty) {
                validator.initialize((NotEmpty)annotation);
            }
            return validator;
        }
    }

    private static class NotNullFactory
    implements ValidatorFactory<NotNullValidator> {
        private NotNullFactory() {
        }

        @Override
        public NotNullValidator create(Annotation annotation) {
            NotNullValidator validator = new NotNullValidator();
            if (annotation instanceof NotNull) {
                validator.initialize((NotNull)annotation);
            }
            return validator;
        }
    }

    private static interface ValidatorFactory<T extends ValidationRule<?, ?>> {
        public T create(Annotation var1);
    }
}

