/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.patterns.mvc.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import com.paypal.android.instrumentation.base.Logging;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.annotations.ViewWithId;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.IBindingModel;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.view.DefaultView;
import com.paypal.android.instrumentation.base.commons.validation.Assert;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;

public class BindingView<T extends IBindingModel>
extends DefaultView<T, View> {
    protected LayoutInflater _inflater;

    public BindingView(int resID) {
        super(resID);
    }

    @Override
    protected View createViewUsingInflater(int layoutResID, Context context) {
        if (this._factory == null) {
            return super.createViewUsingInflater(layoutResID, context);
        }
        this._inflater = LayoutInflater.from((Context)context);
        this._inflater = this._inflater.cloneInContext(context);
        this._inflater.setFactory((LayoutInflater.Factory)this._factory);
        return this._inflater.inflate(layoutResID, null);
    }

    @Override
    protected void initLayout() {
        this.initAndBindFields(this, this._layoutDelegate);
    }

    public void initAndBindFields(Object view, View layoutDelegate) {
        Class<?> viewClass = view.getClass();
        Field[] declaredFields = viewClass.getDeclaredFields();
        Class<?> superclass = viewClass.getSuperclass();
        Field[] superclassDeclaredFields = superclass.getDeclaredFields();
        ArrayList<Field> fieldsList = new ArrayList<Field>();
        fieldsList.addAll(Arrays.asList(declaredFields));
        fieldsList.addAll(Arrays.asList(superclassDeclaredFields));
        for (Field field : fieldsList) {
            ViewWithId viewWithId;
            int componentID;
            View viewById;
            if (!field.isAnnotationPresent(ViewWithId.class)) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            Assert.State.isValid((viewById = layoutDelegate.findViewById(componentID = (viewWithId = field.getAnnotation(ViewWithId.class)).value())) != null, "Can not get view by id, " + componentID);
            Assert.State.isValid(field.getType().isAssignableFrom(viewById.getClass()), "Incompatible types " + field.getType().getName() + " " + viewById.getClass().getName());
            try {
                field.set(view, viewById);
            }
            catch (IllegalAccessException e) {
                Logging.e(Logging.LOG_PREFIX, e.getMessage());
            }
        }
    }
}

