/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.system;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.hardware.Camera;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.nfc.NfcAdapter;
import android.nfc.NfcManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.paypal.android.instrumentation.base.commons.system.PhoneService;
import java.util.Arrays;
import java.util.List;

public class PhoneServiceImpl
implements PhoneService {
    public static final int NETWORK_TYPE_EHRPD = 14;
    public static final int NETWORK_TYPE_HSPAP = 15;
    public static final int NETWORK_TYPE_LTE = 13;
    private final Context _context;
    private ConnectivityManager _connectivityManager;

    public PhoneServiceImpl(Context context) {
        this._context = context;
        this._connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
    }

    @Override
    public void call(String number) {
        Intent intent = new Intent("android.intent.action.DIAL");
        intent.setData(Uri.parse((String)("tel:" + number)));
        this._context.startActivity(intent);
    }

    @Override
    public boolean isOnCall() {
        TelephonyManager telephonyManager = (TelephonyManager)this._context.getSystemService("phone");
        int callState = telephonyManager.getCallState();
        return callState == 2;
    }

    @Override
    public boolean sendEmail(String subject, String body, String[] recipients, Context context) {
        List<String> recipientList = Arrays.asList(recipients);
        Uri recipientsUri = PhoneServiceImpl.generateRecipientsUri(recipientList);
        Intent intent = new Intent("android.intent.action.SENDTO", recipientsUri);
        intent.putExtra("android.intent.extra.SUBJECT", subject);
        intent.putExtra("android.intent.extra.TEXT", body);
        Activity activity = (Activity)context;
        try {
            Intent appChooser = Intent.createChooser((Intent)intent, (CharSequence)"");
            activity.startActivityForResult(appChooser, 1029);
            return true;
        }
        catch (ActivityNotFoundException ex) {
            return false;
        }
    }

    private static Uri generateRecipientsUri(List<String> recipientList) {
        StringBuilder uriBuilder = new StringBuilder();
        for (String recipient : recipientList) {
            if (recipientList.indexOf(recipient) > 0) {
                uriBuilder.append(",");
            }
            uriBuilder.append(recipient);
        }
        return Uri.fromParts((String)"mailto", (String)uriBuilder.toString(), null);
    }

    @Override
    public String getPhoneNumber() {
        TelephonyManager manager = (TelephonyManager)this._context.getSystemService("phone");
        String number = manager.getLine1Number();
        return number == null ? "" : number;
    }

    @Override
    public List<Account> getAccounts() {
        Account[] accounts = AccountManager.get((Context)this._context).getAccounts();
        return Arrays.asList(accounts);
    }

    @Override
    public boolean isConnected() {
        NetworkInfo info = this._connectivityManager.getActiveNetworkInfo();
        return info != null && info.isConnectedOrConnecting();
    }

    @Override
    public boolean isOnFastConnection() {
        NetworkInfo info = this._connectivityManager.getActiveNetworkInfo();
        if (info == null) {
            return false;
        }
        return this.isConnected() && this.isConnectionFast(info.getType(), info.getSubtype());
    }

    @Override
    public boolean isConnectedToWifi() {
        NetworkInfo info = this._connectivityManager.getActiveNetworkInfo();
        if (info == null) {
            return false;
        }
        return this.isOnWifi(info.getType());
    }

    @Override
    public boolean isConnectedToMobile() {
        NetworkInfo info = this._connectivityManager.getActiveNetworkInfo();
        if (info == null) {
            return false;
        }
        return this.isOnMobile(info.getType());
    }

    private boolean isConnectionFast(int type, int subType) {
        if (this.isOnWifi(type)) {
            return true;
        }
        if (this.isOnMobile(type)) {
            switch (subType) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    return false;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    return true;
                }
                case 0: {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    private boolean isOnMobile(int type) {
        return type == 0;
    }

    private boolean isOnWifi(int type) {
        return type == 1;
    }

    @Override
    public boolean isCameraAvailable() {
        try {
            Camera camera = Camera.open();
            camera.release();
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isAirplaneModeOn() {
        try {
            int airplaneMode = Settings.System.getInt((ContentResolver)this._context.getContentResolver(), (String)"airplane_mode_on");
            return airplaneMode != 0;
        }
        catch (Settings.SettingNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean isTapAndPayEnabled() {
        NfcManager manager = (NfcManager)this._context.getSystemService("nfc");
        if (manager == null) {
            return false;
        }
        NfcAdapter adapter = manager.getDefaultAdapter();
        if (Build.VERSION.SDK_INT >= 19) {
            return adapter != null && adapter.isEnabled() && this._context.getPackageManager().hasSystemFeature("android.hardware.nfc.hce");
        }
        return false;
    }
}

