/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.components;

import android.content.Context;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.widget.TextView;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.UIComponent;
import com.paypal.android.instrumentation.base.commons.ui.components.Button;

public class AutoResizeButton
extends Button
implements UIComponent {
    private float _originalTextSize;
    private int _width = 0;

    public AutoResizeButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public AutoResizeButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AutoResizeButton(Context context) {
        this(context, null);
    }

    public void setTextSize(float size) {
        this.setTextSize(0, size);
    }

    public void setTextSize(int unit, float size) {
        super.setTextSize(0, size);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this._width = w;
        this.setText(this.getText());
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(text, type);
        if ((double)this._originalTextSize <= 0.0) {
            this._originalTextSize = this.getTextSize();
        }
        if (this._width > 0) {
            this.setTextSize(this._originalTextSize);
            String textStr = text.toString();
            int length = textStr.length();
            int numChars = this.maxCharLength(textStr);
            int i = 0;
            while (numChars < length) {
                this.setTextSize(this._originalTextSize - (float)i);
                numChars = this.maxCharLength(textStr);
                i += 8;
            }
        }
        this.invalidate();
    }

    public int maxCharLength(String text) {
        String textToBeSplit = text;
        float myTextSize = this.getTextSize();
        Paint paint = new Paint();
        paint.setTextSize(myTextSize);
        return paint.breakText(textToBeSplit, true, (float)this._width, null);
    }
}

