/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.components;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Editable;
import android.util.AttributeSet;
import android.view.View;
import com.paypal.android.instrumentation.base.commons.lang.Optional;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.Binding;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.BindingConnector;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.PropertyChangeEvent;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.TextComponent;
import com.paypal.android.instrumentation.base.commons.ui.components.EditText;
import com.paypal.android.instrumentation.p2pmobile.R;

public class AutoResizeEditText
extends EditText {
    private Paint _textPaint;
    private float _preferredTextSize;
    private float _minTextSize;
    private float _maxTextSize;
    private float _scaledDensity;
    private final BindingConnector _binding = new BindingConnector();
    private TextComponent.UpdateSourceTrigger _trigger = TextComponent.UpdateSourceTrigger.lostFocus;

    public AutoResizeEditText(Context context) {
        super(context, null);
    }

    public AutoResizeEditText(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.autoScaleTextViewStyle);
    }

    public AutoResizeEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this._textPaint = new Paint();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AutoResizeEditText, defStyle, 0);
        this._minTextSize = a.getDimension(R.styleable.AutoResizeEditText_minAutoTextSize, 10.0f);
        this._preferredTextSize = this.getTextSize();
        this._scaledDensity = this.getResources().getDisplayMetrics().scaledDensity;
        this._maxTextSize = a.getDimension(R.styleable.AutoResizeEditText_maxAutoTextSize, this._preferredTextSize);
        a.recycle();
    }

    @Override
    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        Optional<Binding> optBinding;
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (this._trigger.equals((Object)TextComponent.UpdateSourceTrigger.lostFocus) && !focused && (optBinding = this._binding.getBinding(R.styleable.EditText_text)).hasValue()) {
            Editable text = this.getText();
            optBinding.getValue().notifyTargetUpdated(text.toString());
        }
    }

    @Override
    public void propertyChanged(PropertyChangeEvent event) {
        if (this._binding.containsBinding(event._binding)) {
            int bindingAttribute = this._binding.getBindingAttribute(event._binding);
            if (bindingAttribute == R.styleable.EditText_text) {
                String newValue = (String)event.newValue;
                if (this.getText().equals(newValue)) {
                    return;
                }
                this.setText(newValue);
            } else if (bindingAttribute == R.styleable.EditText_textColor) {
                int newValue = (Integer)event.newValue;
                this.setTextColor(newValue);
            }
        }
    }

    @Override
    public void addBinding(int bindingAttribute, Binding binding) {
        this._binding.addBinding(bindingAttribute, binding);
    }

    @Override
    public void setUpdateSourceTrigger(TextComponent.UpdateSourceTrigger trigger) {
        this._trigger = trigger;
    }

    @Override
    public TextComponent.UpdateSourceTrigger getUpdateSourceTrigger() {
        return this._trigger;
    }

    public void setTextSize(float size) {
        if (size <= this.getMaxSize(size)) {
            this._preferredTextSize = size / this._scaledDensity;
            super.setTextSize(this._preferredTextSize);
        }
    }

    public void setMinTextSize(float minTextSize) {
        this._minTextSize = minTextSize;
    }

    @Override
    protected void onTextChanged(CharSequence text, int start, int before, int after) {
        this.refitText(this.getWidth());
        if (this._binding == null || this._trigger.equals((Object)TextComponent.UpdateSourceTrigger.lostFocus)) {
            return;
        }
        Optional<Binding> optBinding = this._binding.getBinding(R.styleable.EditText_text);
        if (optBinding.hasValue()) {
            optBinding.getValue().notifyTargetUpdated(text.toString());
        }
    }

    protected void onSizeChanged(int width, int height, int oldwidth, int oldheight) {
        this.refitText(width);
    }

    public float getMaxSize(float size) {
        float threshold;
        int width = this.getWidth();
        float availableWidth = (float)width - (threshold = this.calculateThreshold());
        if (availableWidth <= 0.0f) {
            return size;
        }
        this._textPaint.setTextSize(size);
        String text = this.getText().toString();
        if (this._textPaint.measureText(text) >= availableWidth) {
            while (size > this._minTextSize && this._textPaint.measureText(text) > availableWidth) {
                if ((size -= 1.0f) <= this._minTextSize) {
                    size = this._minTextSize;
                    break;
                }
                this._textPaint.setTextSize(size);
            }
        } else {
            while (size <= this._maxTextSize && (float)width >= this._textPaint.measureText(text)) {
                this._textPaint.setTextSize(size += 1.0f);
            }
        }
        return size;
    }

    private float calculateThreshold() {
        if (this.getPaddingLeft() > 0) {
            return this.getPaddingLeft();
        }
        View parent = (View)this.getParent();
        if (parent != null && parent.getPaddingLeft() > 0) {
            return parent.getPaddingLeft();
        }
        return 0.0f;
    }

    private void refitText(int textWidth) {
        if (textWidth <= 0) {
            return;
        }
        float trySize = this._preferredTextSize = this.getTextSize();
        float newSize = this.getMaxSize(trySize);
        this.setTextSize(newSize);
    }
}

