/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.components;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.widget.TextView;
import com.paypal.android.instrumentation.p2pmobile.R;

public class AutoResizeTextView
extends TextView {
    private Paint _textPaint = new Paint();
    private float _preferredTextSize;
    private float _minTextSize;

    public AutoResizeTextView(Context context) {
        this(context, null);
    }

    public AutoResizeTextView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.autoScaleTextViewStyle);
    }

    public AutoResizeTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AutoResizeEditText, defStyle, 0);
        this._minTextSize = a.getDimension(R.styleable.AutoResizeEditText_minAutoTextSize, 10.0f);
        a.recycle();
        this._preferredTextSize = this.getTextSize();
    }

    public void setMinTextSize(float minTextSize) {
        this._minTextSize = minTextSize;
    }

    protected void onTextChanged(CharSequence text, int start, int before, int after) {
        this.refitText(text.toString(), this.getWidth());
    }

    protected void onSizeChanged(int width, int height, int oldwidth, int oldheight) {
        if (width != oldwidth) {
            this.refitText(this.getText().toString(), width);
        }
    }

    private void refitText(String text, int textWidth) {
        if (textWidth <= 0 || text == null || text.length() == 0) {
            return;
        }
        int targetWidth = textWidth - this.getPaddingLeft() - this.getPaddingRight();
        float threshold = 0.5f;
        this._textPaint.set((Paint)this.getPaint());
        while (this._preferredTextSize - this._minTextSize > 0.5f) {
            float size = (this._preferredTextSize + this._minTextSize) / 2.0f;
            this._textPaint.setTextSize(size);
            if (this._textPaint.measureText(text) >= (float)targetWidth) {
                this._preferredTextSize = size;
                continue;
            }
            this._minTextSize = size;
        }
        this.setTextSize(0, this._minTextSize);
    }
}

