/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.components;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import com.paypal.android.instrumentation.base.commons.ui.components.LinearLayout;

public class CheckableLinearLayout
extends LinearLayout
implements Checkable {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private boolean mChecked;

    public CheckableLinearLayout(Context context) {
        this(context, null);
        this.init();
    }

    public CheckableLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public boolean performClick() {
        this.toggle();
        return super.performClick();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.checked = this.isChecked();
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setChecked(ss.checked);
        this.requestLayout();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.onTouchEvent(ev);
    }

    public void toggle() {
        this.setChecked(!this.mChecked);
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable drawable = this.getBackground();
        if (drawable != null) {
            int[] myDrawableState = this.getDrawableState();
            drawable.setState(myDrawableState);
            this.invalidate();
        }
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            CheckableLinearLayout.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }

    public void setChecked(boolean checked) {
        if (this.mChecked != checked) {
            this.mChecked = checked;
            this.refreshDrawableState();
            this.setCheckedRecursive((ViewGroup)this, checked);
        }
    }

    private void init() {
    }

    private void setCheckedRecursive(ViewGroup parent, boolean checked) {
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            View v = parent.getChildAt(i);
            if (v instanceof Checkable) {
                ((Checkable)v).setChecked(checked);
            }
            if (!(v instanceof ViewGroup)) continue;
            this.setCheckedRecursive((ViewGroup)v, checked);
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        boolean checked;

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.checked = (Boolean)in.readValue(null);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeValue((Object)this.checked);
        }

        public String toString() {
            return "CheckableLinearLayout.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " checked=" + this.checked + "}";
        }
    }
}

