/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.components;

import android.content.Context;
import android.graphics.Rect;
import android.text.Editable;
import android.util.AttributeSet;
import com.paypal.android.instrumentation.base.commons.lang.Optional;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.Binding;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.BindingConnector;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.PropertyChangeEvent;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.TextComponent;
import com.paypal.android.instrumentation.p2pmobile.R;

public class EditText
extends android.widget.EditText
implements TextComponent {
    private final BindingConnector _binding = new BindingConnector();
    private TextComponent.UpdateSourceTrigger _trigger = TextComponent.UpdateSourceTrigger.lostFocus;

    public EditText(Context context) {
        super(context);
    }

    public EditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public EditText(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        Optional<Binding> optBinding;
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (this._trigger.equals((Object)TextComponent.UpdateSourceTrigger.lostFocus) && !focused && (optBinding = this._binding.getBinding(R.styleable.EditText_text)).hasValue()) {
            Editable text = this.getText();
            optBinding.getValue().notifyTargetUpdated(text.toString());
        }
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        if (this._binding == null || this._trigger.equals((Object)TextComponent.UpdateSourceTrigger.lostFocus)) {
            return;
        }
        Optional<Binding> optBinding = this._binding.getBinding(R.styleable.EditText_text);
        if (optBinding.hasValue()) {
            optBinding.getValue().notifyTargetUpdated(text.toString());
        }
    }

    @Override
    public void propertyChanged(PropertyChangeEvent event) {
        if (this._binding.containsBinding(event._binding)) {
            int bindingAttribute = this._binding.getBindingAttribute(event._binding);
            if (bindingAttribute == R.styleable.EditText_text) {
                String newValue = (String)event.newValue;
                if (this.getText().equals(newValue)) {
                    return;
                }
                this.setText(newValue);
            } else if (bindingAttribute == R.styleable.EditText_textColor) {
                int newValue = (Integer)event.newValue;
                this.setTextColor(newValue);
            }
        }
    }

    @Override
    public void addBinding(int bindingAttribute, Binding binding) {
        this._binding.addBinding(bindingAttribute, binding);
    }

    @Override
    public void setUpdateSourceTrigger(TextComponent.UpdateSourceTrigger trigger) {
        this._trigger = trigger;
    }

    @Override
    public TextComponent.UpdateSourceTrigger getUpdateSourceTrigger() {
        return this._trigger;
    }
}

