/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.components;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewParent;
import com.paypal.android.instrumentation.base.commons.ui.components.LinearLayout;
import com.paypal.android.instrumentation.base.commons.ui.components.ViewGroupOverlay;

public class LinearLayoutOverlay
extends LinearLayout {
    private ViewGroupOverlay _overlay;

    public LinearLayoutOverlay(Context context) {
        super(context);
    }

    public LinearLayoutOverlay(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ViewGroupOverlay getViewOverlay() {
        if (this._overlay == null) {
            this._overlay = new ViewGroupOverlay(this.getContext(), (View)this);
            this.addView((View)this._overlay.getOverlayView());
        }
        return this._overlay;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this._overlay != null) {
            this._overlay.getOverlayView().measure(View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0x40000000));
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this._overlay != null) {
            this._overlay.getOverlayView().layout(this.getLeft(), this.getTop(), this.getLeft() + this.getWidth(), this.getTop() + this.getHeight());
        }
    }

    public void invalidate(int l, int t, int r, int b) {
        super.invalidate(l, t, r, b);
        if (this._overlay != null) {
            this._overlay.getOverlayView().invalidate(l, t, r, b);
        }
    }

    public void invalidate() {
        super.invalidate();
        if (this._overlay != null) {
            this._overlay.getOverlayView().invalidate();
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this._overlay != null && !this._overlay.isEmpty()) {
            this._overlay.getOverlayView().dispatchDraw(canvas);
        }
    }

    public ViewParent invalidateChildInParent(int[] location, Rect dirty) {
        ViewParent parent = super.invalidateChildInParent(location, dirty);
        if (this._overlay != null) {
            this._overlay.getOverlayView().invalidateChildInParent(location, dirty);
            dirty.offset(location[0], location[1]);
        }
        return parent;
    }

    public int getChildCount() {
        if (this._overlay != null) {
            return super.getChildCount() - 1;
        }
        return super.getChildCount();
    }

    public void removeViewOverlay() {
        if (this.hasViewOVerlay()) {
            this.removeView((View)this._overlay.getOverlayView());
            this._overlay = null;
        }
    }

    public boolean hasViewOVerlay() {
        return this._overlay != null;
    }
}

