/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.components;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import com.paypal.android.instrumentation.base.commons.lang.Action;
import com.paypal.android.instrumentation.base.commons.lang.Optional;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.Binding;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.BindingConnector;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.PropertyChangeEvent;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.UIComponent;
import com.paypal.android.instrumentation.p2pmobile.R;
import java.util.List;

public class ListView
extends android.widget.ListView
implements UIComponent {
    private final BindingConnector _binding = new BindingConnector();
    private ListViewAdapter _adapter;
    private int _itemLayout;
    private List<? extends Object> _dataSource;
    private Action<Void, Object> _onItemClickedAction;

    public ListView(Context context) {
        super(context);
    }

    public ListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public void addBinding(int bindingAttribute, Binding binding) {
        this._binding.addBinding(bindingAttribute, binding);
        if (bindingAttribute == R.styleable.ListView_selectedItem) {
            this.setOnItemClickListener(new ListItemClickListener());
        }
    }

    @Override
    public void propertyChanged(PropertyChangeEvent event) {
        List dataSource;
        int bindingAttribute;
        if (this._binding.containsBinding(event._binding) && (bindingAttribute = this._binding.getBindingAttribute(event._binding)) == R.styleable.ListView_dataSource && (dataSource = (List)event.newValue) != null) {
            this._dataSource = dataSource;
            if (this._adapter != null) {
                this._adapter.notifyDataSetChanged();
            }
        }
    }

    public void setItemLayout(int itemLayout) {
        this._itemLayout = itemLayout;
    }

    public int getItemLayout() {
        return this._itemLayout;
    }

    public void setListAdapter(ListViewAdapter adapter) {
        if (adapter == null) {
            return;
        }
        this._adapter = adapter;
        super.setAdapter((ListAdapter)this._adapter);
    }

    public <T> List<T> getDataSource() {
        return this._dataSource;
    }

    public void setOnItemClickedAction(Action<Void, Object> onItemClickedAction) {
        this._onItemClickedAction = onItemClickedAction;
        this.setOnItemClickListener(new ListItemClickListener());
    }

    public static abstract class ListViewAdapter
    extends BaseAdapter {
        public abstract void onItemClick(View var1, int var2);
    }

    private class ListItemClickListener
    implements AdapterView.OnItemClickListener {
        private ListItemClickListener() {
        }

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            List dataSource = ListView.this._dataSource;
            if (dataSource != null) {
                ListAdapter adapter = ListView.this.getAdapter();
                Object object = adapter != null && adapter.getItem(position) != null ? adapter.getItem(position) : dataSource.get(position);
                Optional<Binding> optDataSourceBinding = ListView.this._binding.getBinding(R.styleable.ListView_selectedItem);
                if (optDataSourceBinding.hasValue()) {
                    Binding binding = optDataSourceBinding.getValue();
                    binding.notifyTargetUpdated(object);
                }
                if (ListView.this._onItemClickedAction != null) {
                    ListView.this._onItemClickedAction.invoke(object);
                }
            }
            if (ListView.this._adapter != null) {
                ListView.this._adapter.onItemClick(view, position);
            }
        }
    }
}

