/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.components;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.widget.CompoundButton;
import com.paypal.android.instrumentation.base.commons.lang.Optional;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.Binding;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.BindingConnector;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.PropertyChangeEvent;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.UIComponent;
import com.paypal.android.instrumentation.p2pmobile.R;

@TargetApi(value=14)
public class Switch
extends android.widget.Switch
implements UIComponent {
    private final BindingConnector _binding = new BindingConnector();

    public Switch(Context context) {
        super(context);
    }

    public Switch(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public Switch(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public void propertyChanged(PropertyChangeEvent event) {
        if (this._binding.containsBinding(event._binding)) {
            int bindingAttribute = this._binding.getBindingAttribute(event._binding);
            if (bindingAttribute == R.styleable.Switch_enabled) {
                Boolean enabled = (Boolean)event.newValue;
                this.setEnabled(enabled);
            } else if (bindingAttribute == R.styleable.Switch_visibility) {
                Boolean visible = (Boolean)event.newValue;
                this.setVisibility(visible != false ? 0 : 8);
            } else if (bindingAttribute == R.styleable.Switch_checked) {
                Boolean newValue = (Boolean)event.newValue;
                this.setChecked(newValue);
            }
        }
    }

    @Override
    public void addBinding(int bindingAttribute, Binding binding) {
        this._binding.addBinding(bindingAttribute, binding);
        if (R.styleable.Switch_checked == bindingAttribute) {
            this.setOnCheckedChangeListener(new OnCheckedListener());
        }
    }

    private class OnCheckedListener
    implements CompoundButton.OnCheckedChangeListener {
        private OnCheckedListener() {
        }

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (Switch.this._binding == null) {
                return;
            }
            Optional<Binding> binding = Switch.this._binding.getBinding(R.styleable.Switch_checked);
            if (binding.hasValue()) {
                binding.getValue().notifyTargetUpdated(isChecked);
            }
        }
    }
}

