/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.components;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import com.paypal.android.instrumentation.base.commons.lang.Optional;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.Binding;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.BindingConnector;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.PropertyChangeEvent;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.TextComponent;
import com.paypal.android.instrumentation.base.commons.ui.util.OnTextViewEventListener;
import com.paypal.android.instrumentation.p2pmobile.R;

public class TextView
extends android.widget.TextView
implements TextComponent {
    private final BindingConnector _binding = new BindingConnector();
    private TextComponent.UpdateSourceTrigger _trigger = TextComponent.UpdateSourceTrigger.lostFocus;
    private OnTextViewEventListener _listener;
    private boolean _adjustsFontSizeToFitWidth;

    public TextView(Context context) {
        super(context);
    }

    public TextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public void propertyChanged(PropertyChangeEvent event) {
        if (this._binding.containsBinding(event._binding)) {
            int bindingAttribute = this._binding.getBindingAttribute(event._binding);
            if (bindingAttribute == R.styleable.TextView_text) {
                String newValue = (String)event.newValue;
                if (this.getText().equals(newValue)) {
                    return;
                }
                this.setText(newValue);
            } else if (bindingAttribute == R.styleable.TextView_textColor) {
                int newValue = (Integer)event.newValue;
                this.setTextColor(newValue);
            } else if (bindingAttribute == R.styleable.TextView_visibility) {
                boolean newValue = (Boolean)event.newValue;
                if (newValue) {
                    this.setVisibility(0);
                } else {
                    this.setVisibility(8);
                }
            }
        }
    }

    @Override
    public void addBinding(int bindingAttribute, Binding binding) {
        this._binding.addBinding(bindingAttribute, binding);
    }

    public void setAdjustsFontSizeToFitWidth(boolean adjustsFontSizeToFitWidth) {
        this._adjustsFontSizeToFitWidth = adjustsFontSizeToFitWidth;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this._adjustsFontSizeToFitWidth) {
            this.adjustsFontSizeToFitWidth();
        }
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        if (this._binding == null || this._trigger.equals((Object)TextComponent.UpdateSourceTrigger.lostFocus)) {
            return;
        }
        Optional<Binding> optBinding = this._binding.getBinding(R.styleable.EditText_text);
        if (optBinding.hasValue()) {
            optBinding.getValue().notifyTargetUpdated(text.toString());
        }
    }

    @Override
    public void setUpdateSourceTrigger(TextComponent.UpdateSourceTrigger trigger) {
        this._trigger = trigger;
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        Optional<Binding> optBinding;
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (this._trigger.equals((Object)TextComponent.UpdateSourceTrigger.lostFocus) && !focused && (optBinding = this._binding.getBinding(R.styleable.EditText_text)).hasValue()) {
            CharSequence text = this.getText();
            optBinding.getValue().notifyTargetUpdated(text.toString());
        }
    }

    @Override
    public TextComponent.UpdateSourceTrigger getUpdateSourceTrigger() {
        return this._trigger;
    }

    protected void adjustsFontSizeToFitWidth() {
        int height = this.getHeight();
        int lines = this.getLineCount();
        Rect r = new Rect();
        int y2 = this.getLineBounds(lines - 1, r);
        float size = this.getTextSize();
        if (y2 > height && size >= 8.0f) {
            this.setTextSize(size - 2.0f);
            this.adjustsFontSizeToFitWidth();
        }
    }

    public void setOnTextContextMenuItemListener(OnTextViewEventListener value) {
        this._listener = value;
    }

    public boolean onTextContextMenuItem(int id2) {
        boolean result = super.onTextContextMenuItem(id2);
        if (this._listener != null) {
            switch (id2) {
                case 0x1020020: {
                    this._listener.onCut();
                    break;
                }
                case 0x1020021: {
                    this._listener.onCopy();
                    break;
                }
                case 0x1020022: {
                    this._listener.onPaste();
                    break;
                }
                case 16908341: {
                    this._listener.onShare();
                }
            }
        }
        return result;
    }
}

