/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.components.dialog;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import com.paypal.android.instrumentation.base.commons.ui.components.dialog.AlertDialogBuilder;
import com.paypal.android.instrumentation.base.commons.ui.components.dialog.DialogLeakedException;
import java.util.concurrent.LinkedBlockingQueue;

public class DialogManager {
    private static DialogManager _singleton;
    private final LinkedBlockingQueue<AlertDialog> _queue = new LinkedBlockingQueue();
    private Context _currentContext;

    private DialogManager() {
    }

    public static DialogManager getInstance() {
        if (_singleton == null) {
            _singleton = new DialogManager();
        }
        return _singleton;
    }

    public AlertDialogBuilder setupBuilder(Activity context, DialogInterface.OnDismissListener dismissListener) {
        AlertDialogBuilder alertDialogBuilder = new AlertDialogBuilder((Context)context);
        alertDialogBuilder.setDismissListener(new MyDismissListener(dismissListener));
        return alertDialogBuilder;
    }

    public AlertDialog queueDialog(AlertDialogBuilder alertDialogBuilder, Activity context) throws DialogLeakedException {
        if (this._currentContext == null) {
            this._currentContext = context;
        }
        boolean leakedDialogs = false;
        if (!this._currentContext.equals(context)) {
            leakedDialogs = true;
            this.clear();
        }
        AlertDialog alertDialog = alertDialogBuilder.create();
        this.queueDialog(alertDialog);
        if (leakedDialogs) {
            throw new DialogLeakedException();
        }
        return alertDialog;
    }

    public synchronized void clear() {
        this._queue.clear();
        this._currentContext = null;
    }

    private synchronized void queueDialog(AlertDialog alertDialog) {
        try {
            this._queue.put(alertDialog);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this._queue.size() == 1) {
            this.showNext();
        }
    }

    private synchronized void showNext() {
        if (this._queue.isEmpty()) {
            return;
        }
        AlertDialog alertDialog = this._queue.peek();
        alertDialog.show();
    }

    private synchronized void removeHead() {
        if (this._queue.isEmpty()) {
            this._currentContext = null;
            return;
        }
        try {
            this._queue.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class MyDismissListener
    implements DialogInterface.OnDismissListener {
        private DialogInterface.OnDismissListener _dismissListener;

        public MyDismissListener(DialogInterface.OnDismissListener dismissListener) {
            this._dismissListener = dismissListener;
        }

        public void onDismiss(DialogInterface dialog) {
            if (this._dismissListener != null) {
                this._dismissListener.onDismiss(dialog);
            }
            DialogManager.this.removeHead();
            DialogManager.this.showNext();
        }
    }
}

