/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.factories;

import android.text.Editable;
import android.text.TextWatcher;
import android.widget.EditText;
import android.widget.TextView;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.StringFormatter;
import com.paypal.android.instrumentation.base.commons.ui.factories.AbstractTextViewFactory;

public abstract class AbstractEditTextViewFactory
extends AbstractTextViewFactory {
    @Override
    protected TextWatcher buildWatcher(TextView txt, StringFormatter value, AbstractTextViewFactory.FormatterType formatterType) {
        return new ValueWatcher(txt, value, formatterType);
    }

    private class ValueWatcher
    implements TextWatcher {
        private final StringFormatter _converter;
        private boolean _isConverterCallback;
        private final AbstractTextViewFactory.FormatterType _type;
        private final EditText _textView;

        public ValueWatcher(TextView txt, StringFormatter converter, AbstractTextViewFactory.FormatterType type) {
            this._type = type;
            this._converter = converter;
            this._textView = (EditText)txt;
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (this._type.equals((Object)AbstractTextViewFactory.FormatterType.onTextChanged)) {
                this.handleTextEvent(s.toString());
            }
        }

        public void afterTextChanged(Editable s) {
            if (this._type.equals((Object)AbstractTextViewFactory.FormatterType.afterTextChanged)) {
                this.handleTextEvent(s.toString());
            }
        }

        private void handleTextEvent(String stringToFormat) {
            if (!this._isConverterCallback) {
                this._isConverterCallback = true;
                String formatted = (String)this._converter.format(stringToFormat);
                this._textView.setText((CharSequence)formatted);
                this._textView.setSelection(formatted.length());
                this._isConverterCallback = false;
                this._converter.onFormatComplete(formatted);
            }
        }
    }
}

