/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.factories;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.widget.TextView;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.StringFormatter;
import com.paypal.android.instrumentation.base.commons.ui.factories.UIComponentFactory;
import com.paypal.android.instrumentation.base.commons.ui.util.TypefaceUtil;
import com.paypal.android.instrumentation.base.util.StringUtils;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractTextViewFactory
extends UIComponentFactory {
    protected void stylize(Context context, AttributeSet attrs, TypedArray viewAttributes, TextView txt, int styleAttributeId, int typefaceAttr) {
        String typeface = TypefaceUtil.getTypefaceFromView(context, attrs, typefaceAttr);
        if (StringUtils.isNotEmpty(typeface)) {
            TypefaceUtil.setTypeface(context, txt, typeface);
        } else {
            typeface = TypefaceUtil.getTypefaceFromTheme(context, styleAttributeId, typefaceAttr);
            if (StringUtils.isNotEmpty(typeface)) {
                TypefaceUtil.setTypeface(context, txt, typeface);
            }
        }
    }

    protected void handleFormatter(TextView txt, StringFormatter value, FormatterType formatterType) {
        txt.addTextChangedListener(this.buildWatcher(txt, value, formatterType));
    }

    protected TextWatcher buildWatcher(TextView txt, StringFormatter value, FormatterType formatterType) {
        return new ValueWatcher(txt, value, formatterType);
    }

    private class ValueWatcher
    implements TextWatcher {
        private final StringFormatter _converter;
        private boolean _isConverterCallback;
        private final FormatterType _type;
        private final TextView _textView;

        public ValueWatcher(TextView txt, StringFormatter converter, FormatterType type) {
            this._type = type;
            this._converter = converter;
            this._textView = txt;
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            if (this._type.equals((Object)FormatterType.afterTextChanged) && !this._isConverterCallback) {
                this._isConverterCallback = true;
                String convertedValue = (String)this._converter.format(s.toString());
                s.clear();
                s.insert(0, (CharSequence)convertedValue);
                this._isConverterCallback = false;
                this._converter.onFormatComplete(convertedValue);
            }
        }
    }

    protected static enum FormatterType {
        onTextChanged,
        afterTextChanged,
        beforeTextChanged;

        private static List<FormatterType> s_types;

        public static FormatterType getFormatterType(int index) {
            return s_types.get(index);
        }

        static {
            s_types = Arrays.asList(FormatterType.values());
        }
    }
}

