/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.factories;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.paypal.android.instrumentation.base.commons.lang.Optional;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.CommandContext;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.DataContext;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.TextComponent;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.PropertyValueFormatter;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.StringFormatter;
import com.paypal.android.instrumentation.base.commons.ui.components.AutoResizeEditText;
import com.paypal.android.instrumentation.base.commons.ui.factories.AbstractEditTextViewFactory;
import com.paypal.android.instrumentation.base.commons.ui.factories.AbstractTextViewFactory;
import com.paypal.android.instrumentation.base.commons.validation.Assert;
import com.paypal.android.instrumentation.p2pmobile.R;

public class AutoResizeEditTextFactory
extends AbstractEditTextViewFactory {
    public static final String TAG_NAME = "com.paypal.android.instrumentation.base.commons.ui.components.AutoResizeEditText";

    @Override
    public View createComponent(Context context, AttributeSet attrs, DataContext dataContext, CommandContext commandContext) {
        String formatter;
        Optional<PropertyValueFormatter> propertyFormatter;
        String commandAttributes;
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.AutoResizeEditText);
        if (attributes.getIndexCount() == 0) {
            return new AutoResizeEditText(context, attrs);
        }
        AutoResizeEditText txt = new AutoResizeEditText(context, attrs);
        if (attributes.hasValue(R.styleable.AutoResizeEditText_command)) {
            commandAttributes = attributes.getString(R.styleable.AutoResizeEditText_command);
            this.handleCommandBinding(context, commandAttributes, commandContext, attributes, (View)txt);
        }
        if (attributes.hasValue(R.styleable.AutoResizeEditText_onClick)) {
            commandAttributes = attributes.getString(R.styleable.AutoResizeEditText_onClick);
            this.handleClickCommand(context, commandAttributes, commandContext, attributes, (View)txt);
        }
        if (attributes.hasValue(R.styleable.AutoResizeEditText_onLongClick)) {
            commandAttributes = attributes.getString(R.styleable.AutoResizeEditText_onLongClick);
            this.handleLongClickCommand(context, commandAttributes, commandContext, attributes, (View)txt);
        }
        if (attributes.hasValue(R.styleable.AutoResizeEditText_text)) {
            this.handlePropertyBinding(dataContext, attributes, txt, R.styleable.AutoResizeEditText_text);
        }
        if (attributes.hasValue(R.styleable.AutoResizeEditText_visibility)) {
            this.handlePropertyBinding(dataContext, attributes, txt, R.styleable.AutoResizeEditText_visibility);
        }
        if (attributes.hasValue(R.styleable.AutoResizeEditText_formatter) && (propertyFormatter = dataContext.getPropertyFormatter(formatter = attributes.getString(R.styleable.AutoResizeEditText_formatter))).hasValue()) {
            Assert.Argument.isValid(propertyFormatter.getValue() instanceof StringFormatter, "Invalid PropertyValueFormatter, only StringFormatter is supported!");
            StringFormatter stringFormatter = (StringFormatter)propertyFormatter.getValue();
            int formatterTypeIndex = attributes.getInteger(R.styleable.AutoResizeEditText_formatterType, 1);
            AbstractTextViewFactory.FormatterType type = AbstractTextViewFactory.FormatterType.getFormatterType(formatterTypeIndex);
            this.handleFormatter((TextView)txt, stringFormatter, type);
        }
        if (attributes.hasValue(R.styleable.AutoResizeEditText_updatedSourceTrigger)) {
            int triggerIndex = attributes.getInteger(R.styleable.AutoResizeEditText_updatedSourceTrigger, 1);
            txt.setUpdateSourceTrigger(TextComponent.UpdateSourceTrigger.getUpdateSourceTrigger(triggerIndex));
        }
        attributes.recycle();
        return txt;
    }
}

