/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.factories;

import com.paypal.android.instrumentation.base.commons.lang.Optional;
import com.paypal.android.instrumentation.base.commons.ui.factories.AutoResizeButtonFactory;
import com.paypal.android.instrumentation.base.commons.ui.factories.AutoResizeEditTextFactory;
import com.paypal.android.instrumentation.base.commons.ui.factories.ButtonFactory;
import com.paypal.android.instrumentation.base.commons.ui.factories.CheckBoxFactory;
import com.paypal.android.instrumentation.base.commons.ui.factories.CheckableLinearLayoutFactory;
import com.paypal.android.instrumentation.base.commons.ui.factories.EditTextFactory;
import com.paypal.android.instrumentation.base.commons.ui.factories.FrameLayoutFactory;
import com.paypal.android.instrumentation.base.commons.ui.factories.IUIComponentFactory;
import com.paypal.android.instrumentation.base.commons.ui.factories.ImageButtonFactory;
import com.paypal.android.instrumentation.base.commons.ui.factories.ImageViewFactory;
import com.paypal.android.instrumentation.base.commons.ui.factories.LinearLayoutFactory;
import com.paypal.android.instrumentation.base.commons.ui.factories.ListViewFactory;
import com.paypal.android.instrumentation.base.commons.ui.factories.RelativeLayoutFactory;
import com.paypal.android.instrumentation.base.commons.ui.factories.SwitchFactory;
import com.paypal.android.instrumentation.base.commons.ui.factories.TextViewFactory;
import com.paypal.android.instrumentation.base.commons.ui.factories.ToggleButtonFactory;
import com.paypal.android.instrumentation.base.commons.validation.Assert;
import java.util.HashMap;
import java.util.Map;

public class ComponentFactoryMapper {
    private static final Map<String, IUIComponentFactory> FACTORY_MAP = new HashMap<String, IUIComponentFactory>();

    private ComponentFactoryMapper() {
    }

    public static void registerFactory(String tagName, IUIComponentFactory componentFactory) {
        Assert.Argument.isNotNullNorEmpty("tagName", tagName);
        Assert.Argument.isNotNull("componentFactory", componentFactory);
        FACTORY_MAP.put(tagName, componentFactory);
    }

    public static Optional<IUIComponentFactory> getFactory(String tagName) {
        if (FACTORY_MAP.containsKey(tagName)) {
            return Optional.of(FACTORY_MAP.get(tagName));
        }
        return Optional.absent();
    }

    static {
        FACTORY_MAP.put("Button", new ButtonFactory());
        FACTORY_MAP.put("TextView", new TextViewFactory());
        FACTORY_MAP.put("EditText", new EditTextFactory());
        FACTORY_MAP.put("com.paypal.android.instrumentation.base.commons.ui.components.AutoResizeEditText", new AutoResizeEditTextFactory());
        FACTORY_MAP.put("LinearLayout", new LinearLayoutFactory());
        FACTORY_MAP.put("RelativeLayout", new RelativeLayoutFactory());
        FACTORY_MAP.put("ListView", new ListViewFactory());
        FACTORY_MAP.put("ToggleButton", new ToggleButtonFactory());
        FACTORY_MAP.put("Switch", new SwitchFactory());
        FACTORY_MAP.put("ImageButton", new ImageButtonFactory());
        FACTORY_MAP.put("ImageView", new ImageViewFactory());
        FACTORY_MAP.put("CheckBox", new CheckBoxFactory());
        FACTORY_MAP.put("FrameLayout", new FrameLayoutFactory());
        FACTORY_MAP.put("com.paypal.android.instrumentation.base.commons.ui.components.AutoResizeButton", new AutoResizeButtonFactory());
        FACTORY_MAP.put("com.paypal.android.instrumentation.base.commons.ui.components.CheckableLinearLayout", new CheckableLinearLayoutFactory());
    }
}

