/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.factories;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.paypal.android.instrumentation.base.commons.lang.Optional;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.CommandContext;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.DataContext;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.TextComponent;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.PropertyValueFormatter;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.StringFormatter;
import com.paypal.android.instrumentation.base.commons.ui.components.EditText;
import com.paypal.android.instrumentation.base.commons.ui.factories.AbstractEditTextViewFactory;
import com.paypal.android.instrumentation.base.commons.ui.factories.AbstractTextViewFactory;
import com.paypal.android.instrumentation.base.commons.validation.Assert;
import com.paypal.android.instrumentation.p2pmobile.R;

public class EditTextFactory
extends AbstractEditTextViewFactory {
    public static final String TAG_NAME = "EditText";

    @Override
    public View createComponent(Context context, AttributeSet attrs, DataContext dataContext, CommandContext commandContext) {
        String formatter;
        Optional<PropertyValueFormatter> propertyFormatter;
        String commandAttributes;
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.EditText);
        if (attributes.getIndexCount() == 0) {
            android.widget.EditText editText = new android.widget.EditText(context, attrs);
            this.onAfterCreateComponent((View)editText, attrs);
            return editText;
        }
        EditText txt = new EditText(context, attrs);
        if (attributes.hasValue(R.styleable.EditText_command)) {
            commandAttributes = attributes.getString(R.styleable.EditText_command);
            this.handleCommandBinding(context, commandAttributes, commandContext, attributes, (View)txt);
        }
        if (attributes.hasValue(R.styleable.EditText_onClick)) {
            commandAttributes = attributes.getString(R.styleable.EditText_onClick);
            this.handleClickCommand(context, commandAttributes, commandContext, attributes, (View)txt);
        }
        if (attributes.hasValue(R.styleable.EditText_onLongClick)) {
            commandAttributes = attributes.getString(R.styleable.EditText_onLongClick);
            this.handleLongClickCommand(context, commandAttributes, commandContext, attributes, (View)txt);
        }
        if (attributes.hasValue(R.styleable.EditText_text)) {
            this.handlePropertyBinding(dataContext, attributes, txt, R.styleable.EditText_text);
        }
        if (attributes.hasValue(R.styleable.EditText_visibility)) {
            this.handlePropertyBinding(dataContext, attributes, txt, R.styleable.EditText_visibility);
        }
        if (attributes.hasValue(R.styleable.EditText_formatter) && (propertyFormatter = dataContext.getPropertyFormatter(formatter = attributes.getString(R.styleable.EditText_formatter))).hasValue()) {
            Assert.Argument.isValid(propertyFormatter.getValue() instanceof StringFormatter, "Invalid PropertyValueFormatter, only StringFormatter is supported!");
            StringFormatter stringFormatter = (StringFormatter)propertyFormatter.getValue();
            int formatterTypeIndex = attributes.getInteger(R.styleable.EditText_formatterType, 1);
            AbstractTextViewFactory.FormatterType type = AbstractTextViewFactory.FormatterType.getFormatterType(formatterTypeIndex);
            this.handleFormatter((TextView)txt, stringFormatter, type);
        }
        if (attributes.hasValue(R.styleable.EditText_updatedSourceTrigger)) {
            int triggerIndex = attributes.getInteger(R.styleable.EditText_updatedSourceTrigger, 1);
            txt.setUpdateSourceTrigger(TextComponent.UpdateSourceTrigger.getUpdateSourceTrigger(triggerIndex));
        }
        this.onAfterCreateComponent((View)txt, attrs);
        attributes.recycle();
        return txt;
    }

    @Override
    public void onAfterCreateComponent(View view, AttributeSet attrs) {
        super.onAfterCreateComponent(view, attrs);
        if (view instanceof android.widget.EditText) {
            Context context = view.getContext();
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.EditText);
            this.stylize(context, attrs, attributes, (TextView)view, 16842862, R.attr.typeface);
        }
    }
}

