/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.factories;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import com.paypal.android.instrumentation.base.commons.lang.Optional;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.CommandContext;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.DataContext;
import com.paypal.android.instrumentation.base.commons.ui.factories.ComponentFactoryMapper;
import com.paypal.android.instrumentation.base.commons.ui.factories.IUIComponentFactory;
import com.paypal.android.instrumentation.base.commons.validation.Assert;

public class LayoutFactory
implements LayoutInflater.Factory {
    private DataContext _dataContext;
    private CommandContext _commandContext;

    public LayoutFactory(DataContext dataContext, CommandContext commandContext) {
        Assert.Argument.isNotNull("dataContext", dataContext);
        Assert.Argument.isNotNull("commandContext", commandContext);
        this._dataContext = dataContext;
        this._commandContext = commandContext;
    }

    public View onCreateView(String name, Context context, AttributeSet attrs) {
        Optional<IUIComponentFactory> optFactory = ComponentFactoryMapper.getFactory(name);
        if (optFactory.hasValue()) {
            IUIComponentFactory componentFactory = optFactory.getValue();
            return componentFactory.createComponent(context, attrs, this._dataContext, this._commandContext);
        }
        return null;
    }
}

